/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.SkinUUID;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public class SkinDocumentNode {
    private Vector3f location = Vector3f.ZERO;
    private Vector3f rotation = Vector3f.ZERO;
    private Vector3f scale = Vector3f.ONE;
    private Vector3f pivot = Vector3f.ZERO;
    private SkinTransform transform = null;
    private ISkinPartType type;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private String name;
    private SkinDocumentNode parent;
    private SkinDocumentListener listener;
    private boolean isEnabled = true;
    private boolean isMirror = false;
    private final String id;
    private final ArrayList<SkinDocumentNode> children = new ArrayList();
    private String cachedTypeName;

    public SkinDocumentNode(String name) {
        this(SkinUUID.randomUUIDString(), name);
    }

    public SkinDocumentNode(String id, String name) {
        this(id, name, SkinPartTypes.ADVANCED);
    }

    public SkinDocumentNode(String id, String name, ISkinPartType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public SkinDocumentNode(CompoundTag tag) {
        this.id = tag.m_128461_("UID");
        this.name = OptionalAPI.getOptionalString(tag, "Name", null);
        this.type = OptionalAPI.getOptionalType(tag, "Type", SkinPartTypes.ADVANCED, SkinPartTypes::byName);
        this.skin = OptionalAPI.getOptionalSkinDescriptor(tag, "Skin");
        this.location = OptionalAPI.getOptionalVector3f(tag, "Location", Vector3f.ZERO);
        this.rotation = OptionalAPI.getOptionalVector3f(tag, "Rotation", Vector3f.ZERO);
        this.scale = OptionalAPI.getOptionalVector3f(tag, "Scale", Vector3f.ONE);
        this.pivot = OptionalAPI.getOptionalVector3f(tag, "Pivot", Vector3f.ZERO);
        if (tag.m_128441_("Children")) {
            ListTag listTag = tag.m_128437_("Children", 10);
            int count = listTag.size();
            for (int i = 0; i < count; ++i) {
                SkinDocumentNode node = new SkinDocumentNode(listTag.m_128728_(i));
                node.parent = this;
                this.children.add(node);
            }
        }
        this.isEnabled = OptionalAPI.getOptionalBoolean(tag, "Enabled", true);
        this.isMirror = OptionalAPI.getOptionalBoolean(tag, "Mirror", false);
    }

    public void add(SkinDocumentNode node) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        this.children.add(node);
        node.parent = this;
        node.setListener(this.listener);
        if (this.listener != null) {
            this.listener.documentDidInsertNode(this, node, -1);
        }
    }

    public void insertAtIndex(SkinDocumentNode node, int index) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        this.children.add(index, node);
        node.parent = this;
        node.setListener(this.listener);
        if (this.listener != null) {
            this.listener.documentDidInsertNode(this, node, index);
        }
    }

    public void moveTo(SkinDocumentNode node, int toIndex) {
        int index = this.children.indexOf(node);
        if (index < 0 || index == toIndex) {
            return;
        }
        this.children.remove(index);
        this.children.add(MathUtils.clamp(toIndex, 0, this.children.size()), node);
        if (this.listener != null) {
            this.listener.documentDidMoveNode(this, node, toIndex);
        }
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        if (this.listener != null) {
            this.listener.documentDidRemoveNode(this);
        }
        this.parent.children.remove(this);
        this.parent = null;
        this.setListener(null);
    }

    public void setName(String value) {
        this.name = value;
        this.cachedTypeName = null;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalString(tag, "Name", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.cachedTypeName != null) {
            return this.cachedTypeName;
        }
        MutableComponent lhs = TranslateUtils.title("documentType.armourers_workshop.node.root", new Object[0]);
        MutableComponent rhs = TranslateUtils.title("documentType.armourers_workshop.node." + this.id, new Object[0]);
        if (this.type != SkinPartTypes.ADVANCED) {
            rhs = TranslateUtils.Name.of(this.type);
        }
        this.cachedTypeName = TranslateUtils.title("documentType.armourers_workshop.node", lhs, rhs).getString();
        return this.cachedTypeName;
    }

    public void setType(ISkinPartType type) {
        this.type = type;
        this.cachedTypeName = null;
    }

    public ISkinPartType getType() {
        return this.type;
    }

    public void setSkin(SkinDescriptor value) {
        this.skin = value;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public SkinDescriptor getSkin() {
        return this.skin;
    }

    public void setLocation(Vector3f value) {
        this.location = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalVector3f(tag, "Location", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public void setRotation(Vector3f value) {
        this.rotation = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalVector3f(tag, "Rotation", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setScale(float value) {
        this.scale = new Vector3f(value, value, value);
        this.transform = null;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalVector3f(tag, "Scale", this.scale, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public float getScale() {
        return this.scale.getX();
    }

    public void setPivot(Vector3f value) {
        this.pivot = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            OptionalAPI.putOptionalVector3f(tag, "Pivot", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public SkinTransform getTransform() {
        if (this.transform != null) {
            return this.transform;
        }
        Vector3f translate = this.location;
        Vector3f pivot = this.pivot;
        if (!translate.equals(Vector3f.ZERO)) {
            translate = new Vector3f(-translate.getX(), -translate.getY(), translate.getZ());
        }
        if (!pivot.equals(Vector3f.ZERO)) {
            pivot = new Vector3f(-pivot.getX(), -pivot.getY(), pivot.getZ());
        }
        Vector3f scale = this.scale;
        if (this.isMirror) {
            scale = scale.scaling(-1.0f, 1.0f, 1.0f);
        }
        this.transform = SkinTransform.create(translate, this.rotation, scale, pivot, Vector3f.ZERO);
        return this.transform;
    }

    public String getId() {
        return this.id;
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Enabled", value);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setMirror(boolean value) {
        this.isMirror = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Mirror", value);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public boolean isLocked() {
        return this.name == null;
    }

    public boolean isStatic() {
        return this.type == SkinPartTypes.ADVANCED_STATIC;
    }

    public boolean isFloat() {
        return this.type == SkinPartTypes.ADVANCED_FLOAT;
    }

    public boolean isLocator() {
        return this.type == SkinPartTypes.ADVANCED_LOCATOR;
    }

    public boolean isBasic() {
        return this.type != SkinPartTypes.ADVANCED && this.type != SkinPartTypes.ADVANCED_STATIC && this.type != SkinPartTypes.ADVANCED_FLOAT && this.type != SkinPartTypes.ADVANCED_LOCATOR;
    }

    public SkinDocumentNode parent() {
        return this.parent;
    }

    public ArrayList<SkinDocumentNode> children() {
        return this.children;
    }

    protected void setListener(SkinDocumentListener listener) {
        this.listener = listener;
        this.children.forEach(it -> it.setListener(listener));
    }

    protected SkinDocumentListener getListener() {
        return this.listener;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("UID", this.id);
        OptionalAPI.putOptionalString(tag, "Name", this.name, null);
        OptionalAPI.putOptionalType(tag, "Type", this.type, SkinPartTypes.ADVANCED);
        OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", this.skin);
        OptionalAPI.putOptionalVector3f(tag, "Location", this.location, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "Rotation", this.rotation, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "Scale", this.scale, Vector3f.ONE);
        OptionalAPI.putOptionalVector3f(tag, "Pivot", this.pivot, Vector3f.ZERO);
        if (!this.children.isEmpty()) {
            ListTag listTag = new ListTag();
            this.children.forEach(it -> listTag.add((Object)it.serializeNBT()));
            tag.m_128365_("Children", (Tag)listTag);
        }
        OptionalAPI.putOptionalBoolean(tag, "Enabled", this.isEnabled, true);
        OptionalAPI.putOptionalBoolean(tag, "Mirror", this.isMirror, false);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        String newName;
        Vector3f newPivot;
        Vector3f newScale;
        Vector3f newRotation;
        Vector3f newLocation;
        SkinDescriptor newSkin = OptionalAPI.getOptionalSkinDescriptor(tag, "Skin", null);
        if (newSkin != null) {
            this.skin = newSkin;
        }
        if ((newLocation = OptionalAPI.getOptionalVector3f(tag, "Location", null)) != null) {
            this.location = newLocation;
            this.transform = null;
        }
        if ((newRotation = OptionalAPI.getOptionalVector3f(tag, "Rotation", null)) != null) {
            this.rotation = newRotation;
            this.transform = null;
        }
        if ((newScale = OptionalAPI.getOptionalVector3f(tag, "Scale", null)) != null) {
            this.scale = newScale;
            this.transform = null;
        }
        if ((newPivot = OptionalAPI.getOptionalVector3f(tag, "Pivot", null)) != null) {
            this.pivot = newPivot;
            this.transform = null;
        }
        if ((newName = OptionalAPI.getOptionalString(tag, "Name", null)) != null) {
            this.name = newName;
        }
        if (tag.m_128441_("Enabled")) {
            this.isEnabled = tag.m_128471_("Enabled");
        }
        if (tag.m_128441_("Mirror")) {
            this.isMirror = tag.m_128471_("Mirror");
        }
        this.listener.documentDidUpdateNode(this, tag);
    }

    public static class Keys {
        public static final String UID = "UID";
        public static final String NAME = "Name";
        public static final String TYPE = "Type";
        public static final String SKIN = "Skin";
        public static final String LOCATION = "Location";
        public static final String ROTATION = "Rotation";
        public static final String SCALE = "Scale";
        public static final String PIVOT = "Pivot";
        public static final String CHILDREN = "Children";
        public static final String ENABLED = "Enabled";
        public static final String MIRROR = "Mirror";
    }
}

