/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.face;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.core.Direction;

public class SkinCuller {
    private static final int DIRECTION_SIZE = Direction.values().length;
    private static final ImmutableMap<ISkinPartType, Partition> PARTITIONS2 = ImmutableMap.builder().put((Object)SkinPartTypes.BIPPED_HAT, (Object)new Simple(SkinPartTypes.BIPPED_HAT)).put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new Simple(SkinPartTypes.BIPPED_HEAD)).put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new Limb(SkinPartTypes.BIPPED_CHEST, SkinPartTypes.BIPPED_TORSO, 6)).put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new Limb(SkinPartTypes.BIPPED_LEFT_ARM, SkinPartTypes.BIPPED_LEFT_HAND, 4)).put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new Limb(SkinPartTypes.BIPPED_RIGHT_ARM, SkinPartTypes.BIPPED_RIGHT_HAND, 4)).put((Object)SkinPartTypes.BIPPED_SKIRT, (Object)new Simple(SkinPartTypes.BIPPED_SKIRT)).put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new Limb(SkinPartTypes.BIPPED_LEFT_THIGH, SkinPartTypes.BIPPED_LEFT_LEG, 6)).put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new Limb(SkinPartTypes.BIPPED_RIGHT_THIGH, SkinPartTypes.BIPPED_RIGHT_LEG, 6)).put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, (Object)new Simple(SkinPartTypes.BIPPED_LEFT_FOOT)).put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, (Object)new Simple(SkinPartTypes.BIPPED_RIGHT_FOOT)).put((Object)SkinPartTypes.BIPPED_LEFT_WING, (Object)new Simple(SkinPartTypes.BIPPED_LEFT_WING)).put((Object)SkinPartTypes.BIPPED_RIGHT_WING, (Object)new Simple(SkinPartTypes.BIPPED_RIGHT_WING)).build();

    private static Partition getPartition(ISkinPartType partType) {
        Partition partition;
        if (ModConfig.Client.enablePartSubdivide && (partition = (Partition)PARTITIONS2.get((Object)partType)) != null) {
            return partition;
        }
        return new Simple(partType);
    }

    public static Collection<SearchResult> cullFaces2(SkinCubes cubeData, Rectangle3i bounds, ISkinPartType partType) {
        Collection<ISkinCubeType> cubeTypes = cubeData.getCubeTypes();
        if (cubeTypes != null && cubeTypes.contains(SkinCubeTypes.TEXTURE)) {
            return SkinCuller.allFaces(cubeData, bounds, partType);
        }
        Partition partition = SkinCuller.getPartition(partType);
        IndexedMap indexedMap = new IndexedMap(cubeData, bounds);
        Collection<SearchResult> results = partition.subdivide(bounds);
        for (SearchResult result : results) {
            result.cull(cubeData, indexedMap);
        }
        for (int i = 0; i < cubeData.getCubeTotal(); ++i) {
            SkinCube cube = null;
            for (Direction dir : Direction.values()) {
                for (SearchResult result : results) {
                    SkinCubeFace face;
                    if (!result.flags.get(i * DIRECTION_SIZE + dir.m_122411_())) continue;
                    if (cube == null) {
                        cube = cubeData.getCube(i);
                    }
                    if ((face = cube.getFace(dir)) == null) continue;
                    result.add(face);
                }
            }
        }
        return results;
    }

    public static Collection<SearchResult> allFaces(SkinCubes cubeData, Rectangle3i bounds, ISkinPartType partType) {
        SearchResult result = new SearchResult(partType, bounds, Vector3i.ZERO);
        for (int i = 0; i < cubeData.getCubeTotal(); ++i) {
            SkinCube cube = cubeData.getCube(i);
            for (Direction dir : Direction.values()) {
                SkinCubeFace face = cube.getFace(dir);
                if (face == null) continue;
                result.add(face);
            }
        }
        return Collections.singleton(result);
    }

    public static ArrayList<SkinCubeFace> cullFaces(SkinCubes cubeData, Rectangle3i bounds) {
        IndexedMap indexedMap = new IndexedMap(cubeData, bounds);
        Rectangle3i rect = new Rectangle3i(0, 0, 0, bounds.getWidth(), bounds.getHeight(), bounds.getDepth());
        BitSet flags = SkinCuller.cullFaceFlags(cubeData, indexedMap, rect);
        ArrayList<SkinCubeFace> faces = new ArrayList<SkinCubeFace>();
        for (int i = 0; i < cubeData.getCubeTotal(); ++i) {
            SkinCube cube = null;
            for (Direction dir : Direction.values()) {
                SkinCubeFace face;
                if (!flags.get(i * DIRECTION_SIZE + dir.m_122411_())) continue;
                if (cube == null) {
                    cube = cubeData.getCube(i);
                }
                if ((face = cube.getFace(dir)) == null) continue;
                faces.add(face);
            }
        }
        return faces;
    }

    private static BitSet cullFaceFlags(SkinCubes cubeData, IndexedMap map, Rectangle3i rect) {
        BitSet flags = new BitSet(cubeData.getCubeTotal() * DIRECTION_SIZE);
        Rectangle3i searchArea = new Rectangle3i(rect.getX() - 1, rect.getY() - 1, rect.getZ() - 1, rect.getWidth() + 2, rect.getHeight() + 2, rect.getDepth() + 2);
        HashSet<Vector3i> closedSet = new HashSet<Vector3i>();
        ArrayDeque<Vector3i> openList = new ArrayDeque<Vector3i>();
        Vector3i start = searchArea.getOrigin();
        openList.add(start);
        closedSet.add(start);
        map.limit(rect);
        while (!openList.isEmpty()) {
            ArrayList<Vector3i> pendingList = new ArrayList<Vector3i>();
            Vector3i pos = (Vector3i)openList.poll();
            for (Direction advance : Direction.values()) {
                Vector3i pos1 = pos.relative(advance, 1);
                int targetIndex = map.get(pos1);
                if (targetIndex == -1) {
                    pendingList.add(pos1);
                    continue;
                }
                boolean isBlank = false;
                ISkinCubeType targetCube = cubeData.getCube(targetIndex).getType();
                if (targetCube.isGlass()) {
                    pendingList.add(pos1);
                    int sourceIndex = map.get(pos);
                    if (sourceIndex != -1) {
                        isBlank = cubeData.getCube(sourceIndex).getType().isGlass();
                    }
                }
                Direction facing = advance;
                if (advance.m_122434_() == Direction.Axis.Z) {
                    facing = advance.m_122424_();
                }
                flags.set(targetIndex * DIRECTION_SIZE + facing.m_122411_(), !isBlank);
            }
            for (Vector3i pos1 : pendingList) {
                if (!searchArea.contains(pos1) || closedSet.contains(pos1)) continue;
                closedSet.add(pos1);
                openList.add(pos1);
            }
        }
        return flags;
    }

    static interface Partition {
        public Collection<SearchResult> subdivide(Rectangle3i var1);
    }

    static class Simple
    implements Partition {
        final ISkinPartType partType;

        public Simple(ISkinPartType partType) {
            this.partType = partType;
        }

        @Override
        public Collection<SearchResult> subdivide(Rectangle3i rect) {
            Rectangle3i box = new Rectangle3i(0, 0, 0, rect.getWidth(), rect.getHeight(), rect.getDepth());
            return Collections.singleton(new SearchResult(this.partType, box, Vector3i.ZERO));
        }
    }

    public static class IndexedMap {
        public final int size;
        public final int x;
        public final int y;
        public final int z;
        public final int width;
        public final int height;
        public final int depth;
        private final int[][][] indexes;
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;

        public IndexedMap(SkinCubes cubeData, Rectangle3i bounds) {
            this.size = cubeData.getCubeTotal();
            this.x = bounds.getX();
            this.y = bounds.getY();
            this.z = bounds.getZ();
            this.width = bounds.getWidth();
            this.height = bounds.getHeight();
            this.depth = bounds.getDepth();
            this.indexes = new int[this.depth][this.height][this.width];
            for (int i = 0; i < this.size; ++i) {
                Vector3i pos = cubeData.getCube(i).getPosition();
                int x = pos.getX() - this.x;
                int y = pos.getY() - this.y;
                int z = pos.getZ() - this.z;
                this.indexes[z][y][x] = i + 1;
            }
            this.limit(new Rectangle3i(0, 0, 0, this.width, this.height, this.depth));
        }

        public void limit(Rectangle3i limit) {
            this.minX = Math.max(limit.getMinX(), 0);
            this.minY = Math.max(limit.getMinY(), 0);
            this.minZ = Math.max(limit.getMinZ(), 0);
            this.maxX = Math.min(limit.getMaxX(), this.width);
            this.maxY = Math.min(limit.getMaxY(), this.height);
            this.maxZ = Math.min(limit.getMaxZ(), this.depth);
        }

        public int get(Vector3i pos) {
            return this.get(pos.getX(), pos.getY(), pos.getZ());
        }

        public int get(int x, int y, int z) {
            if (x < this.minX || x >= this.maxX) {
                return -1;
            }
            if (y < this.minY || y >= this.maxY) {
                return -1;
            }
            if (z < this.minZ || z >= this.maxZ) {
                return -1;
            }
            return this.indexes[z][y][x] - 1;
        }
    }

    public static class SearchResult {
        protected final ISkinPartType partType;
        protected final Rectangle3i bounds;
        protected final Vector3i origin;
        protected BitSet flags;
        protected ArrayList<SkinCubeFace> faces = new ArrayList();

        public SearchResult(ISkinPartType partType, Rectangle3i bounds, Vector3i origin) {
            this.partType = partType;
            this.bounds = bounds;
            this.origin = origin;
        }

        public void add(SkinCubeFace face) {
            this.faces.add(face);
        }

        public void cull(SkinCubes cubeData, IndexedMap map) {
            this.flags = SkinCuller.cullFaceFlags(cubeData, map, this.bounds);
        }

        public ISkinPartType getPartType() {
            return this.partType;
        }

        public ArrayList<SkinCubeFace> getFaces() {
            return this.faces;
        }

        public Vector3i getOrigin() {
            return this.origin;
        }

        public Rectangle3i getBounds() {
            return this.bounds;
        }
    }

    static class Limb
    extends Simple {
        final ISkinPartType upperPartType;
        final ISkinPartType lowerPartType;
        final int yClip;

        public Limb(ISkinPartType upperPartType, ISkinPartType lowerPartType, int yClip) {
            super(upperPartType);
            this.upperPartType = upperPartType;
            this.lowerPartType = lowerPartType;
            this.yClip = yClip;
        }

        @Override
        public Collection<SearchResult> subdivide(Rectangle3i rect) {
            int upper = this.yClip - rect.getMinY();
            int lower = rect.getMaxY() - this.yClip;
            if (lower > 0 && upper > 0) {
                Rectangle3i upperBox = new Rectangle3i(0, 0, 0, rect.getWidth(), upper, rect.getDepth());
                Rectangle3i lowerBox = new Rectangle3i(0, upper, 0, rect.getWidth(), lower, rect.getDepth());
                SearchResult upperResult = new SearchResult(this.upperPartType, upperBox, Vector3i.ZERO);
                SearchResult lowerResult = new SearchResult(this.lowerPartType, lowerBox, new Vector3i(0, -this.yClip, 0));
                return ObjectUtils.map(upperResult, lowerResult);
            }
            return super.subdivide(rect);
        }
    }
}

