/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.core.skin.molang.core.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Variable;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Compiler;
import moe.plushie.armourers_workshop.core.skin.molang.impl.SyntaxException;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;

public class MolangVirtualMachine {
    private static final MolangVirtualMachine DEFAULT = new MolangVirtualMachine();
    private final Compiler compiler = new Compiler();
    private final Map<String, Variable> variables = new ConcurrentHashMap<String, Variable>();
    public final Variable animTime = this.register("query.anim_time", 0.0);
    public final Variable lifeTime = this.register("query.life_time", 0.0);
    public final Variable actorCount = this.register("query.actor_count", 0.0);
    public final Variable timeOfDay = this.register("query.time_of_day", 0.0);
    public final Variable moonPhase = this.register("query.moon_phase", 0.0);
    public final Variable distanceFromCamera = this.register("query.distance_from_camera", 0.0);
    public final Variable isOnGround = this.register("query.is_on_ground", 0.0);
    public final Variable isInWater = this.register("query.is_in_water", 0.0);
    public final Variable isInWaterOrRain = this.register("query.is_in_water_or_rain", 0.0);
    public final Variable health = this.register("query.health", 0.0);
    public final Variable maxHealth = this.register("query.max_health", 0.0);
    public final Variable isOnFire = this.register("query.is_on_fire", 0.0);
    public final Variable groundSpeed = this.register("query.ground_speed", 0.0);
    public final Variable yawSpeed = this.register("query.yaw_speed", 0.0);

    public static MolangVirtualMachine get() {
        return DEFAULT;
    }

    public Expression eval(String source) throws SyntaxException {
        Expression expr = this.compiler.compile(source);
        if (ModConfig.Client.enableMolangDebug && !(expr instanceof Constant)) {
            ModLog.debug("source: {}", source);
            ModLog.debug("compiled: {}", expr);
        }
        return expr;
    }

    public Variable register(String name, double value) {
        Variable variable = new Variable(name, value);
        this.compiler.registerVariable(name, variable);
        this.variables.put(name, variable);
        return variable;
    }

    public Map<String, ? extends Variable> getVariables() {
        return this.variables;
    }
}

