/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Ternary;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Property;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public final class Binary
implements Expression {
    private final Op op;
    private final Expression left;
    private final Expression right;

    public Binary(Op op, Expression left, Expression rhs) {
        this.op = op;
        this.left = left;
        this.right = rhs;
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitBinary(this);
    }

    @Override
    public boolean isMutable() {
        return this.left.isMutable() || this.right.isMutable();
    }

    @Override
    public double getAsDouble() {
        return this.op.compute(this.left, this.right);
    }

    public String toString() {
        return this.escape(this.left) + " " + this.op.symbol() + " " + this.escape(this.right);
    }

    public Op op() {
        return this.op;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    private String escape(Expression expression) {
        if (expression instanceof Binary || expression instanceof Ternary) {
            return "(" + String.valueOf(expression) + ")";
        }
        return expression.toString();
    }

    public static enum Op {
        AND("&&", 300){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs != 0.0 && rhs != 0.0 ? 1.0 : 0.0;
            }
        }
        ,
        OR("||", 200){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs != 0.0 || rhs != 0.0 ? 1.0 : 0.0;
            }
        }
        ,
        LT("<", 700){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs < rhs ? 1.0 : 0.0;
            }
        }
        ,
        LTE("<=", 700){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs <= rhs ? 1.0 : 0.0;
            }
        }
        ,
        GT(">", 700){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs > rhs ? 1.0 : 0.0;
            }
        }
        ,
        GTE(">=", 700){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs >= rhs ? 1.0 : 0.0;
            }
        }
        ,
        ADD("+", 900){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs + rhs;
            }
        }
        ,
        SUB("-", 900){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs - rhs;
            }
        }
        ,
        MUL("*", 1000){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs * rhs;
            }
        }
        ,
        DIV("/", 1000){

            @Override
            public double compute(double lhs, double rhs) {
                return rhs == 0.0 ? lhs : lhs / rhs;
            }
        }
        ,
        MOD("%", 1000){

            @Override
            public double compute(double lhs, double rhs) {
                return rhs == 0.0 ? lhs : lhs % rhs;
            }
        }
        ,
        POW("^", 1500){

            @Override
            public double compute(double lhs, double rhs) {
                return Math.pow(lhs, rhs);
            }
        }
        ,
        ARROW("->", 2000){

            @Override
            public double compute(Expression lhs, Expression rhs) {
                return 0.0;
            }
        }
        ,
        NULL_COALESCE("??", 2){

            @Override
            public double compute(Expression lhs, Expression rhs) {
                Property property;
                if (lhs instanceof Property && (property = (Property)((Object)lhs)).isNull()) {
                    property.update(rhs.getAsExpression());
                }
                return 0.0;
            }
        }
        ,
        ASSIGN("=", 1){

            @Override
            public double compute(Expression lhs, Expression rhs) {
                if (lhs instanceof Property) {
                    Property property = (Property)((Object)lhs);
                    property.update(rhs.getAsExpression());
                }
                return 0.0;
            }
        }
        ,
        CONDITIONAL("?", 1){

            @Override
            public double compute(Expression lhs, Expression rhs) {
                return lhs.getAsBoolean() ? rhs.getAsDouble() : 0.0;
            }
        }
        ,
        EQ("==", 500){

            @Override
            public double compute(double lhs, double rhs) {
                return Math.abs(lhs - rhs) < 1.0E-5 ? 1.0 : 0.0;
            }
        }
        ,
        NEQ("!=", 500){

            @Override
            public double compute(double lhs, double rhs) {
                return Math.abs(lhs - rhs) >= 1.0E-5 ? 1.0 : 0.0;
            }
        };

        private final String symbol;
        private final int precedence;

        private Op(String symbol, int precedence) {
            this.symbol = symbol;
            this.precedence = precedence;
        }

        public String symbol() {
            return this.symbol;
        }

        public int precedence() {
            return this.precedence;
        }

        public double compute(double lhs, double rhs) {
            return 0.0;
        }

        public double compute(Expression lhs, Expression rhs) {
            return this.compute(lhs.getAsDouble(), rhs.getAsDouble());
        }
    }
}

