/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import java.util.List;
import java.util.StringJoiner;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public abstract class Function
implements Expression {
    private final String name;
    private final List<Expression> arguments;

    protected Function(String name, int requirement, List<Expression> arguments) {
        this.name = name;
        this.arguments = arguments;
        if (arguments.size() < requirement) {
            throw new IllegalArgumentException(String.format("Function '%s' at least %s arguments. Only %s given!", name, requirement, arguments.size()));
        }
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitFunction(this);
    }

    @Override
    public boolean isMutable() {
        for (Expression value : this.arguments) {
            if (!value.isMutable()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Expression arg : this.arguments) {
            joiner.add(arg.toString());
        }
        return this.name + String.valueOf(joiner);
    }

    public String name() {
        return this.name;
    }

    public List<Expression> arguments() {
        return this.arguments;
    }

    @FunctionalInterface
    public static interface Factory<T extends Function> {
        public T create(String var1, List<Expression> var2);
    }
}

