/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.impl.FlowControllable;
import moe.plushie.armourers_workshop.core.skin.molang.impl.FlowController;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public final class Statement
implements Expression,
FlowControllable {
    private final Op op;
    private final FlowController controller;

    public Statement(Op op) {
        this.op = op;
        this.controller = FlowController.instruct();
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitStatement(this);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public double getAsDouble() {
        this.controller.setInterrupt(this.op.mode());
        return 0.0;
    }

    public String toString() {
        return this.op.symbol();
    }

    @Override
    public FlowController controller() {
        return this.controller;
    }

    public Op op() {
        return this.op;
    }

    public static enum Op {
        BREAK("break", FlowController.State.BREAK),
        CONTINUE("continue", FlowController.State.CONTINUE);

        private final FlowController.State mode;
        private final String symbol;

        private Op(String symbol, FlowController.State mode) {
            this.mode = mode;
            this.symbol = symbol;
        }

        public FlowController.State mode() {
            return this.mode;
        }

        public String symbol() {
            return this.symbol;
        }
    }
}

