/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public final class Ternary
implements Expression {
    private final Expression condition;
    private final Expression trueValue;
    private final Expression falseValue;

    public Ternary(Expression condition, Expression trueValue, Expression falseValue) {
        this.condition = condition;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitTernary(this);
    }

    @Override
    public boolean isMutable() {
        return this.condition.isMutable() || this.trueValue.isMutable() || this.falseValue.isMutable();
    }

    @Override
    public double getAsDouble() {
        return this.condition.getAsBoolean() ? this.trueValue.getAsDouble() : this.falseValue.getAsDouble();
    }

    public String toString() {
        return this.condition.toString() + " ? " + this.trueValue.toString() + " : " + this.falseValue.toString();
    }

    public Expression condition() {
        return this.condition;
    }

    public Expression trueValue() {
        return this.trueValue;
    }

    public Expression falseValue() {
        return this.falseValue;
    }
}

