/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import moe.plushie.armourers_workshop.core.skin.molang.core.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public final class Unary
implements Expression {
    private final Op op;
    private final Expression value;

    public Unary(Op op, Expression value) {
        this.op = op;
        this.value = value;
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitUnary(this);
    }

    @Override
    public boolean isMutable() {
        return this.value.isMutable();
    }

    @Override
    public double getAsDouble() {
        return this.op.compute(this.value);
    }

    public String toString() {
        Object contents = this.value.toString();
        if (this.value instanceof Constant) {
            contents = "(" + (String)contents + ")";
        }
        return this.op.symbol() + (String)contents;
    }

    public Op op() {
        return this.op;
    }

    public Expression value() {
        return this.value;
    }

    public static enum Op {
        LOGICAL_NEGATION("!"){

            @Override
            public double compute(Expression expression) {
                return expression.getAsBoolean() ? 0.0 : 1.0;
            }
        }
        ,
        ARITHMETICAL_NEGATION("-"){

            @Override
            public double compute(Expression expression) {
                return -expression.getAsDouble();
            }
        };

        private final String symbol;

        private Op(String symbol) {
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        public abstract double compute(Expression var1);
    }
}

