/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.core;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Property;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public final class Variable
implements Expression,
Property {
    private final String name;
    private int type = 0;
    private double value;
    private DoubleSupplier provider;

    public Variable(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public Variable(String name, DoubleSupplier provider) {
        this.name = name;
        this.provider = provider;
    }

    @Override
    public void update(Expression expression) {
        this.set(expression);
    }

    @Override
    public Expression visit(Visitor visitor) {
        return visitor.visitVariable(this);
    }

    public void set(double value) {
        this.value = value;
        this.provider = null;
        this.type = 1;
    }

    public void set(DoubleSupplier value) {
        this.provider = value;
        this.type = 2;
    }

    public void set(boolean value) {
        this.set(value ? 1.0 : 0.0);
    }

    public void set(BooleanSupplier value) {
        this.set(() -> value.getAsBoolean() ? 1.0 : 0.0);
    }

    @Override
    public boolean isNull() {
        return this.type == 0;
    }

    @Override
    public double getAsDouble() {
        if (this.provider != null) {
            return this.provider.getAsDouble();
        }
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public String name() {
        return this.name;
    }
}

