/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.function.random;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Function;
import org.jetbrains.annotations.Nullable;

public final class DieRoll
extends Function {
    private final Expression rolls;
    private final Expression min;
    private final Expression max;
    @Nullable
    private final Expression seed;
    @Nullable
    private final Random random;

    public DieRoll(String name, List<Expression> arguments) {
        super(name, 3, arguments);
        this.rolls = arguments.get(0);
        this.min = arguments.get(1);
        this.max = arguments.get(2);
        this.seed = arguments.size() >= 4 ? arguments.get(3) : null;
        this.random = this.seed != null ? new Random() : null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public double getAsDouble() {
        Random random;
        int rolls = (int)Math.floor(this.rolls.getAsDouble());
        double min = this.min.getAsDouble();
        double max = this.max.getAsDouble();
        double sum = 0.0;
        if (this.random != null) {
            random = this.random;
            random.setSeed((long)this.seed.getAsDouble());
        } else {
            random = ThreadLocalRandom.current();
        }
        for (int i = 0; i < rolls; ++i) {
            sum += min + random.nextDouble() * (max - min);
        }
        return sum;
    }
}

