/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.function.random;

import java.util.List;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Function;
import org.jetbrains.annotations.Nullable;

public final class Random
extends Function {
    private final Expression valueA;
    @Nullable
    private final Expression valueB;
    @Nullable
    private final Expression seed;
    @Nullable
    private final java.util.Random random;

    public Random(String name, List<Expression> arguments) {
        super(name, 1, arguments);
        this.valueA = arguments.get(0);
        this.valueB = arguments.size() >= 2 ? arguments.get(1) : null;
        this.seed = arguments.size() >= 3 ? arguments.get(2) : null;
        this.random = this.seed != null ? new java.util.Random() : null;
    }

    @Override
    public double getAsDouble() {
        double result;
        double valueA = this.valueA.getAsDouble();
        if (this.random != null) {
            this.random.setSeed((long)this.seed.getAsDouble());
            result = this.random.nextDouble();
        } else {
            result = Math.random();
        }
        if (this.valueB != null) {
            double valueB = this.valueB.getAsDouble();
            double min = Math.min(valueA, valueB);
            double max = Math.max(valueA, valueB);
            result = min + result * (max - min);
        } else {
            result *= valueA;
        }
        return result;
    }
}

