/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.impl;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.core.skin.molang.core.Binary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Compound;
import moe.plushie.armourers_workshop.core.skin.molang.core.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.ForEach;
import moe.plushie.armourers_workshop.core.skin.molang.core.Function;
import moe.plushie.armourers_workshop.core.skin.molang.core.Identifier;
import moe.plushie.armourers_workshop.core.skin.molang.core.Literal;
import moe.plushie.armourers_workshop.core.skin.molang.core.Loop;
import moe.plushie.armourers_workshop.core.skin.molang.core.Return;
import moe.plushie.armourers_workshop.core.skin.molang.core.Statement;
import moe.plushie.armourers_workshop.core.skin.molang.core.Subscript;
import moe.plushie.armourers_workshop.core.skin.molang.core.Ternary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Unary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Variable;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.ACos;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.ASin;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.ATan;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.ATan2;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Abs;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Cos;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Exp;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Log;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Mod;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Pow;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Sin;
import moe.plushie.armourers_workshop.core.skin.molang.function.generic.Sqrt;
import moe.plushie.armourers_workshop.core.skin.molang.function.limit.Clamp;
import moe.plushie.armourers_workshop.core.skin.molang.function.limit.Max;
import moe.plushie.armourers_workshop.core.skin.molang.function.limit.Min;
import moe.plushie.armourers_workshop.core.skin.molang.function.misc.Pi;
import moe.plushie.armourers_workshop.core.skin.molang.function.misc.Print;
import moe.plushie.armourers_workshop.core.skin.molang.function.misc.ToDeg;
import moe.plushie.armourers_workshop.core.skin.molang.function.misc.ToRad;
import moe.plushie.armourers_workshop.core.skin.molang.function.random.DieRoll;
import moe.plushie.armourers_workshop.core.skin.molang.function.random.DieRollInteger;
import moe.plushie.armourers_workshop.core.skin.molang.function.random.Random;
import moe.plushie.armourers_workshop.core.skin.molang.function.random.RandomInteger;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.Ceil;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.Floor;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.HermiteBlend;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.Lerp;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.LerpRot;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.Round;
import moe.plushie.armourers_workshop.core.skin.molang.function.round.Truncate;
import moe.plushie.armourers_workshop.core.skin.molang.impl.KeyPath;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Lexer;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Optimizer;
import moe.plushie.armourers_workshop.core.skin.molang.impl.SyntaxException;

public class Compiler {
    protected final Optimizer optimizer;
    protected final Map<KeyPath, Variable> variables = new ConcurrentHashMap<KeyPath, Variable>();
    protected final Map<KeyPath, Function.Factory<?>> functions = new ConcurrentHashMap();
    private final Map<String, KeyPath> mapping = new ConcurrentHashMap<String, KeyPath>();
    private final Map<String, String> aliases = ImmutableMap.builder().put((Object)"c", (Object)"context").put((Object)"q", (Object)"query").put((Object)"t", (Object)"temp").put((Object)"v", (Object)"variable").build();

    public Compiler() {
        this.optimizer = new Optimizer(this);
        this.registerVariable("PI", new Variable("PI", Math.PI));
        this.registerVariable("E", new Variable("E", Math.E));
        this.registerFunction("math.floor", Floor::new);
        this.registerFunction("math.round", Round::new);
        this.registerFunction("math.ceil", Ceil::new);
        this.registerFunction("math.trunc", Truncate::new);
        this.registerFunction("math.clamp", Clamp::new);
        this.registerFunction("math.max", Max::new);
        this.registerFunction("math.min", Min::new);
        this.registerFunction("math.abs", Abs::new);
        this.registerFunction("math.acos", ACos::new);
        this.registerFunction("math.asin", ASin::new);
        this.registerFunction("math.atan", ATan::new);
        this.registerFunction("math.atan2", ATan2::new);
        this.registerFunction("math.cos", Cos::new);
        this.registerFunction("math.sin", Sin::new);
        this.registerFunction("math.exp", Exp::new);
        this.registerFunction("math.ln", Log::new);
        this.registerFunction("math.sqrt", Sqrt::new);
        this.registerFunction("math.mod", Mod::new);
        this.registerFunction("math.pow", Pow::new);
        this.registerFunction("math.lerp", Lerp::new);
        this.registerFunction("math.lerprotate", LerpRot::new);
        this.registerFunction("math.hermite_blend", HermiteBlend::new);
        this.registerFunction("math.die_roll", DieRoll::new);
        this.registerFunction("math.die_roll_integer", DieRollInteger::new);
        this.registerFunction("math.random", Random::new);
        this.registerFunction("math.random_integer", RandomInteger::new);
        this.registerFunction("math.pi", Pi::new);
        this.registerFunction("math.to_deg", ToDeg::new);
        this.registerFunction("math.to_rad", ToRad::new);
        this.registerFunction("print", Print::new);
        this.registerFunction("loop", Loop::new);
        this.registerFunction("for_each", ForEach::new);
    }

    public void registerFunction(String name, Function.Factory<?> factory) {
        this.functions.put(KeyPath.of(name.toLowerCase()), factory);
    }

    public void registerVariable(String name, Variable variable) {
        KeyPath key = this.parseName(name.toLowerCase());
        this.variables.put(key, variable);
    }

    public Expression getFunction(String name, List<Expression> arguments) {
        KeyPath key = KeyPath.of(name.toLowerCase());
        Function.Factory<?> factory = this.functions.get(key);
        if (factory != null) {
            return factory.create(key.toString(), arguments);
        }
        return null;
    }

    public Variable getVariable(String name) {
        KeyPath key = this.parseName(name.toLowerCase());
        return this.variables.computeIfAbsent(key, it -> new Variable(it.toString(), 0.0));
    }

    public Expression compile(String source) throws SyntaxException {
        Expression expression = this.parseAll(source);
        expression = this.optimizer.optimize(expression);
        return expression;
    }

    private Expression parseAll(String source) throws SyntaxException {
        Lexer.Token token;
        Lexer lexer = new Lexer(source);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        while ((token = lexer.next()).kind() != Lexer.Kind.EOF) {
            if (token.kind() == Lexer.Kind.ERROR) {
                throw new SyntaxException("Found an invalid token (error): " + token.value(), lexer.cursor());
            }
            Expression expr = this.parseCompoundExpression(lexer, 0);
            token = lexer.current();
            if (token.kind() != Lexer.Kind.EOF && token.kind() != Lexer.Kind.SEMICOLON) {
                throw new SyntaxException("Expected a semicolon, but was " + String.valueOf(token), lexer.cursor());
            }
            expressions.add(expr);
        }
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return new Compound(expressions);
    }

    private Expression parseSingle(Lexer lexer) throws SyntaxException {
        Lexer.Token token = lexer.current();
        return switch (token.kind()) {
            case Lexer.Kind.NUMBER -> {
                lexer.next();
                yield new Constant(Double.parseDouble(token.value()));
            }
            case Lexer.Kind.STRING -> {
                lexer.next();
                yield new Literal(token.value());
            }
            case Lexer.Kind.TRUE -> {
                lexer.next();
                yield Constant.ONE;
            }
            case Lexer.Kind.FALSE -> {
                lexer.next();
                yield Constant.ZERO;
            }
            case Lexer.Kind.LPAREN -> {
                lexer.next();
                Expression expression = this.parseCompoundExpression(lexer, 0);
                token = lexer.current();
                if (token.kind() != Lexer.Kind.RPAREN) {
                    throw new SyntaxException("Non closed expression", lexer.cursor());
                }
                lexer.next();
                yield expression;
            }
            case Lexer.Kind.LBRACE -> {
                token = lexer.next();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                while (token.kind() != Lexer.Kind.RBRACE) {
                    expressions.add(this.parseCompoundExpression(lexer, 0));
                    token = lexer.current();
                    if (token.kind() == Lexer.Kind.RBRACE) break;
                    if (token.kind() == Lexer.Kind.EOF) {
                        throw new SyntaxException("Found the end before the execution scope closing token", lexer.cursor());
                    }
                    if (token.kind() == Lexer.Kind.ERROR) {
                        throw new SyntaxException("Found an invalid token (error): " + token.value(), lexer.cursor());
                    }
                    if (token.kind() != Lexer.Kind.SEMICOLON) {
                        throw new SyntaxException("Missing semicolon", lexer.cursor());
                    }
                    token = lexer.next();
                }
                lexer.next();
                yield new Compound(expressions);
            }
            case Lexer.Kind.BREAK -> {
                lexer.next();
                yield new Statement(Statement.Op.BREAK);
            }
            case Lexer.Kind.CONTINUE -> {
                lexer.next();
                yield new Statement(Statement.Op.CONTINUE);
            }
            case Lexer.Kind.IDENTIFIER -> {
                Object name = token.value();
                token = lexer.next();
                while (token.kind() == Lexer.Kind.DOT) {
                    token = lexer.next();
                    if (token.kind() != Lexer.Kind.IDENTIFIER) {
                        throw new SyntaxException("Unexpected token, expected a valid field token", lexer.cursor());
                    }
                    name = (String)name + "." + token.value();
                    token = lexer.next();
                }
                if (token.kind() == Lexer.Kind.LPAREN) {
                    yield this.parseCompound(lexer, new Identifier((String)name), 0);
                }
                if (token.kind() == Lexer.Kind.LBRACKET) {
                    yield this.parseCompound(lexer, this.getVariable((String)name), 0);
                }
                yield this.getVariable((String)name);
            }
            case Lexer.Kind.SUB -> {
                lexer.next();
                Expression expr = this.parseSingle(lexer);
                if (expr instanceof Constant) {
                    Constant constant = (Constant)expr;
                    yield new Constant(-constant.getAsDouble());
                }
                yield new Unary(Unary.Op.ARITHMETICAL_NEGATION, expr);
            }
            case Lexer.Kind.BANG -> {
                lexer.next();
                Expression expr = this.parseSingle(lexer);
                yield new Unary(Unary.Op.LOGICAL_NEGATION, expr);
            }
            case Lexer.Kind.RETURN -> {
                lexer.next();
                Expression expr = this.parseCompoundExpression(lexer, 0);
                yield new Return(expr);
            }
            default -> Constant.ZERO;
        };
    }

    private Expression parseCompoundExpression(Lexer lexer, int lastPrecedence) throws SyntaxException {
        Expression expr = this.parseSingle(lexer);
        while (true) {
            Expression compoundExpr = this.parseCompound(lexer, expr, lastPrecedence);
            Lexer.Token current = lexer.current();
            if (current.kind() == Lexer.Kind.EOF || current.kind() == Lexer.Kind.SEMICOLON) {
                return compoundExpr;
            }
            if (compoundExpr == expr) {
                return expr;
            }
            expr = compoundExpr;
        }
    }

    private Expression parseCompound(Lexer lexer, Expression left, int lastPrecedence) throws SyntaxException {
        Binary.Op op;
        Lexer.Token current = lexer.current();
        switch (current.kind()) {
            case RPAREN: 
            case EOF: {
                return left;
            }
            case LBRACKET: {
                current = lexer.next();
                if (current.kind() == Lexer.Kind.RBRACKET) {
                    throw new SyntaxException("Expected a expression, got RBRACKET", lexer.cursor());
                }
                if (current.kind() == Lexer.Kind.EOF) {
                    throw new SyntaxException("Found EOF before closing RBRACKET", lexer.cursor());
                }
                Expression index = this.parseCompoundExpression(lexer, 0);
                current = lexer.current();
                if (current.kind() == Lexer.Kind.EOF) {
                    throw new SyntaxException("Found EOF before closing RBRACKET", lexer.cursor());
                }
                if (current.kind() != Lexer.Kind.RBRACKET) {
                    throw new SyntaxException("Expected a closing RBRACKET, found " + String.valueOf(current), lexer.cursor());
                }
                lexer.next();
                return new Subscript(left, index);
            }
            case LPAREN: {
                current = lexer.next();
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                if (current.kind() == Lexer.Kind.EOF) {
                    throw new SyntaxException("Found EOF before closing RPAREN", lexer.cursor());
                }
                while (current.kind() != Lexer.Kind.RPAREN) {
                    arguments.add(this.parseCompoundExpression(lexer, 0));
                    current = lexer.current();
                    if (current.kind() == Lexer.Kind.EOF) {
                        throw new SyntaxException("Found EOF before closing RPAREN", lexer.cursor());
                    }
                    if (current.kind() == Lexer.Kind.ERROR) {
                        throw new SyntaxException("Found error token: " + current.value(), lexer.cursor());
                    }
                    if (current.kind() == Lexer.Kind.RPAREN) break;
                    if (current.kind() != Lexer.Kind.COMMA) {
                        throw new SyntaxException("Expected a comma, got " + String.valueOf((Object)current.kind()), lexer.cursor());
                    }
                    lexer.next();
                }
                lexer.next();
                Expression expr = this.getFunction(left.getAsString(), arguments);
                if (expr == null) {
                    throw new SyntaxException("Not found function: " + String.valueOf(left), lexer.cursor());
                }
                return expr;
            }
            case QUES: {
                lexer.next();
                Expression trueValue = this.parseCompoundExpression(lexer, 0);
                if (lexer.current().kind() == Lexer.Kind.COLON) {
                    lexer.next();
                    Expression falseValue = this.parseCompoundExpression(lexer, 0);
                    return new Ternary(left, trueValue, falseValue);
                }
                return new Binary(Binary.Op.CONDITIONAL, left, trueValue);
            }
        }
        switch (current.kind()) {
            case AMPAMP: {
                Binary.Op op2 = Binary.Op.AND;
                break;
            }
            case BARBAR: {
                Binary.Op op2 = Binary.Op.OR;
                break;
            }
            case LT: {
                Binary.Op op2 = Binary.Op.LT;
                break;
            }
            case LTE: {
                Binary.Op op2 = Binary.Op.LTE;
                break;
            }
            case GT: {
                Binary.Op op2 = Binary.Op.GT;
                break;
            }
            case GTE: {
                Binary.Op op2 = Binary.Op.GTE;
                break;
            }
            case PLUS: {
                Binary.Op op2 = Binary.Op.ADD;
                break;
            }
            case SUB: {
                Binary.Op op2 = Binary.Op.SUB;
                break;
            }
            case STAR: {
                Binary.Op op2 = Binary.Op.MUL;
                break;
            }
            case SLASH: {
                Binary.Op op2 = Binary.Op.DIV;
                break;
            }
            case QUESQUES: {
                Binary.Op op2 = Binary.Op.NULL_COALESCE;
                break;
            }
            case EQ: {
                Binary.Op op2 = Binary.Op.ASSIGN;
                break;
            }
            case EQEQ: {
                Binary.Op op2 = Binary.Op.EQ;
                break;
            }
            case BANGEQ: {
                Binary.Op op2 = Binary.Op.NEQ;
                break;
            }
            case ARROW: {
                Binary.Op op2 = Binary.Op.ARROW;
                break;
            }
            default: {
                Binary.Op op2 = op = null;
            }
        }
        if (op == null || lastPrecedence >= op.precedence()) {
            return left;
        }
        lexer.next();
        Expression right = this.parseCompoundExpression(lexer, op.precedence());
        return new Binary(op, left, right);
    }

    protected KeyPath parseName(String name) {
        KeyPath key = this.mapping.get(name);
        if (key != null) {
            return key;
        }
        key = KeyPath.parse(name);
        String resolvedName = this.aliases.get(key.getName());
        if (resolvedName != null) {
            key = new KeyPath(resolvedName, key.getChild());
        }
        this.mapping.put(name, key);
        return key;
    }
}

