/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.impl;

import java.util.List;
import java.util.Stack;
import moe.plushie.armourers_workshop.core.skin.molang.core.Compound;
import moe.plushie.armourers_workshop.core.skin.molang.core.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Function;
import moe.plushie.armourers_workshop.core.skin.molang.impl.FlowControllable;
import moe.plushie.armourers_workshop.core.skin.molang.impl.TreeVisitor;
import org.jetbrains.annotations.Nullable;

public class FlowController {
    private FlowController parent;
    private State state = State.NONE;
    private Expression result = Constant.ZERO;
    private final Kind kind;

    public FlowController(Kind kind) {
        this.kind = kind;
    }

    public static FlowController block(List<Expression> expressions) {
        FlowController control = new FlowController(Kind.BLOCK);
        Applier applier = new Applier(control);
        expressions.forEach(it -> it.visit(applier));
        return control;
    }

    public static FlowController enumerate(Expression expression) {
        FlowController control = new FlowController(Kind.ENUMERATE);
        Applier applier = new Applier(control);
        expression.visit(applier);
        return control;
    }

    public static FlowController instruct() {
        return new FlowController(Kind.INSTRUCT);
    }

    public void begin() {
        this.state = State.NONE;
        this.result = Constant.ZERO;
    }

    public Expression end() {
        return this.result;
    }

    public State interrupt() {
        return this.state;
    }

    public void setInterrupt(State state) {
        this.setInterrupt(state, Constant.ZERO);
    }

    public void setInterrupt(State state, Expression result) {
        Kind target = this.findTarget(state);
        FlowController controller = this.parent;
        while (controller != null) {
            controller.state = state;
            if (controller.kind == target) {
                controller.result = result;
                break;
            }
            controller = controller.parent;
        }
    }

    public FlowController parent() {
        return this.parent;
    }

    public void setParent(FlowController parent) {
        this.parent = parent;
    }

    @Nullable
    private Kind findTarget(State state) {
        return switch (state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 3 -> Kind.BLOCK;
            case 1, 2 -> Kind.ENUMERATE;
            case 0 -> null;
        };
    }

    public static enum State {
        NONE,
        BREAK,
        CONTINUE,
        RETURN;


        public boolean isContinueOrBreakOrReturn() {
            return this != NONE;
        }

        public boolean isBreakOrReturn() {
            return this == BREAK || this == RETURN;
        }
    }

    public static enum Kind {
        BLOCK,
        ENUMERATE,
        INSTRUCT;

    }

    public static class Applier
    extends TreeVisitor {
        private final Stack<FlowController> stack = new Stack();

        public Applier(FlowController control) {
            this.stack.push(control);
        }

        @Override
        public Expression visit(Expression expression) {
            FlowControllable controllable;
            if (expression instanceof FlowControllable && (controllable = (FlowControllable)((Object)expression)).controller() != this.stack.peek()) {
                controllable.controller().setParent(this.stack.peek());
            }
            return expression;
        }

        @Override
        public Expression visitFunction(Function expression) {
            FlowControllable controllable;
            if (expression instanceof FlowControllable && (controllable = (FlowControllable)((Object)expression)).controller().parent() != this.stack.peek()) {
                controllable.controller().setParent(this.stack.peek());
                this.stack.push(controllable.controller());
                super.visitFunction(expression);
                this.stack.pop();
            }
            return expression;
        }

        @Override
        public Expression visitCompound(Compound expression) {
            if (expression.controller().parent() != this.stack.peek()) {
                expression.controller().setParent(this.stack.peek());
                this.stack.push(expression.controller());
                super.visitCompound(expression);
                this.stack.pop();
            }
            return expression;
        }
    }
}

