/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.impl;

import java.util.Objects;

public final class KeyPath {
    private final String name;
    private final KeyPath child;

    public KeyPath(String name) {
        this.name = name;
        this.child = null;
    }

    public KeyPath(String name, KeyPath child) {
        this.name = name;
        this.child = child;
    }

    public static KeyPath of(String name) {
        return new KeyPath(name);
    }

    public static KeyPath parse(String name) {
        String[] keys = name.split("\\.");
        int index = keys.length;
        if (index <= 1) {
            return KeyPath.of(name);
        }
        KeyPath key = new KeyPath(keys[--index]);
        while (index > 0) {
            key = new KeyPath(keys[--index], key);
        }
        return key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyPath)) {
            return false;
        }
        KeyPath that = (KeyPath)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.child);
    }

    public String toString() {
        if (this.child != null) {
            return this.name + "." + String.valueOf(this.child);
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public KeyPath getChild() {
        return this.child;
    }
}

