/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.impl;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.molang.core.Binary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Compound;
import moe.plushie.armourers_workshop.core.skin.molang.core.Constant;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Function;
import moe.plushie.armourers_workshop.core.skin.molang.core.Optimized;
import moe.plushie.armourers_workshop.core.skin.molang.core.Return;
import moe.plushie.armourers_workshop.core.skin.molang.core.Statement;
import moe.plushie.armourers_workshop.core.skin.molang.core.Subscript;
import moe.plushie.armourers_workshop.core.skin.molang.core.Ternary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Unary;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Compiler;
import moe.plushie.armourers_workshop.core.skin.molang.impl.TreeVisitor;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public final class Optimizer
implements Visitor {
    private final Compiler compiler;

    public Optimizer(Compiler compiler) {
        this.compiler = compiler;
    }

    public Expression optimize(Expression expression) {
        if (expression.isMutable()) {
            return expression.visit(this);
        }
        if (expression instanceof Constant) {
            return expression;
        }
        if (this.hasControlFlow(expression)) {
            return expression;
        }
        return new Optimized(expression);
    }

    public List<Expression> optimize(List<Expression> expressions) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            results.add(this.optimize(expression));
        }
        return results;
    }

    @Override
    public Expression visit(Expression expression) {
        return expression;
    }

    @Override
    public Expression visitSubscript(Subscript expression) {
        return new Subscript(expression.variable(), this.optimize(expression.index()));
    }

    @Override
    public Expression visitUnary(Unary expression) {
        return new Unary(expression.op(), this.optimize(expression.value()));
    }

    @Override
    public Expression visitBinary(Binary expression) {
        return new Binary(expression.op(), this.optimize(expression.left()), this.optimize(expression.right()));
    }

    @Override
    public Expression visitTernary(Ternary expression) {
        return new Ternary(this.optimize(expression.condition()), this.optimize(expression.trueValue()), this.optimize(expression.falseValue()));
    }

    @Override
    public Expression visitFunction(Function expression) {
        Expression result = this.compiler.getFunction(expression.name(), this.optimize(expression.arguments()));
        if (result != null) {
            return result;
        }
        return expression;
    }

    @Override
    public Expression visitCompound(Compound expression) {
        return new Compound(this.optimize(expression.expressions()));
    }

    @Override
    public Expression visitReturn(Return expression) {
        return new Return(this.optimize(expression.value()));
    }

    private boolean hasControlFlow(Expression expression) {
        List<Expression> results = TreeVisitor.filter(expression, it -> it instanceof Statement || it instanceof Return);
        return !results.isEmpty();
    }
}

