/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.core.skin.molang.core.Binary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Compound;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Function;
import moe.plushie.armourers_workshop.core.skin.molang.core.Return;
import moe.plushie.armourers_workshop.core.skin.molang.core.Subscript;
import moe.plushie.armourers_workshop.core.skin.molang.core.Ternary;
import moe.plushie.armourers_workshop.core.skin.molang.core.Unary;
import moe.plushie.armourers_workshop.core.skin.molang.impl.Visitor;

public abstract class TreeVisitor
implements Visitor {
    public static List<Expression> filter(Expression expr, final Predicate<Expression> filter) {
        final ArrayList<Expression> results = new ArrayList<Expression>();
        expr.visit(new TreeVisitor(){

            @Override
            public Expression visit(Expression expression) {
                if (filter.test(expression)) {
                    results.add(expression);
                }
                return expression;
            }
        });
        return results;
    }

    @Override
    public Expression visitSubscript(Subscript expression) {
        expression.variable().visit(this);
        expression.index().visit(this);
        return this.visit(expression);
    }

    @Override
    public Expression visitUnary(Unary expression) {
        expression.value().visit(this);
        return this.visit(expression);
    }

    @Override
    public Expression visitBinary(Binary expression) {
        expression.left().visit(this);
        expression.right().visit(this);
        return this.visit(expression);
    }

    @Override
    public Expression visitTernary(Ternary expression) {
        expression.condition().visit(this);
        expression.trueValue().visit(this);
        expression.falseValue().visit(this);
        return this.visit(expression);
    }

    @Override
    public Expression visitFunction(Function expression) {
        for (Expression argument : expression.arguments()) {
            argument.visit(this);
        }
        return this.visit(expression);
    }

    @Override
    public Expression visitCompound(Compound expression) {
        for (Expression argument : expression.expressions()) {
            argument.visit(this);
        }
        return this.visit(expression);
    }

    @Override
    public Expression visitReturn(Return expression) {
        expression.value().visit(this);
        return this.visit(expression);
    }
}

