/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.impl.test;

import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;

public class CompilerTest {
    public static void main() {
        try {
            CompilerTest.test1();
            CompilerTest.test2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test1() throws Exception {
        CompilerTest.assertEquals("-99", -99.0);
        CompilerTest.assertEquals("math.sin(90)", Math.sin(1.5707963267948966));
        CompilerTest.assertEquals("math.abs(90+1)", 91.0);
        CompilerTest.assertEquals("-Math.abs(-90)", -90.0);
        CompilerTest.assertEquals("!math.abs(90)", 0.0);
        CompilerTest.assertEquals("!q.a[0]", 1.0);
        CompilerTest.assertEquals("v.a=1;loop(10,{v.a=v.a+1;(v.A>=3)?break;});return V.a;", 3.0);
    }

    private static void test2() throws Exception {
        CompilerTest.assertEquals("math.sin(q.modified_distance_moved*90)*0.05-0.05", -0.05);
    }

    private static void assertEquals(String source, double expectedValue) throws Exception {
        double resultValue = MolangVirtualMachine.get().eval(source).getAsDouble();
        if (Math.abs(resultValue - expectedValue) > 1.0E-15) {
            throw new AssertionError((Object)("Source \"" + source + "\", expected " + expectedValue + " but got " + resultValue));
        }
    }
}

