/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class SkinProperties
implements ISkinProperties {
    public static final SkinProperties EMPTY = new SkinProperties();
    protected final LinkedHashMap<String, Object> properties;

    public SkinProperties() {
        this.properties = new LinkedHashMap();
    }

    public SkinProperties(CompoundTag tag) {
        this();
        this.readFromNBT(tag);
    }

    public SkinProperties(LinkedHashMap<String, Object> properties) {
        this.properties = properties;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public <T> T get(ISkinProperty<T> property) {
        Object value = this.properties.getOrDefault(property.getKey(), property.getDefaultValue());
        return ObjectUtils.unsafeCast(value);
    }

    @Override
    public <T> void put(ISkinProperty<T> property, T value) {
        if (Objects.equals(value, property.getDefaultValue())) {
            this.properties.remove(property.getKey());
        } else {
            this.properties.put(property.getKey(), value);
        }
    }

    public void putAll(SkinProperties properties) {
        this.properties.putAll(properties.properties);
    }

    public void clear() {
        this.properties.clear();
    }

    @Override
    public <T> void remove(ISkinProperty<T> property) {
        this.properties.remove(property.getKey());
    }

    @Override
    public <T> boolean containsKey(ISkinProperty<T> property) {
        return this.properties.containsKey(property.getKey());
    }

    @Override
    public <T> boolean containsValue(ISkinProperty<T> property) {
        return this.properties.containsValue(property.getKey());
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    public ArrayList<String> getPropertiesList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.properties.size(); ++i) {
            String key = (String)this.properties.keySet().toArray()[i];
            list.add(key + ":" + String.valueOf(this.properties.get(key)));
        }
        return list;
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeInt(this.properties.size());
        for (int i = 0; i < this.properties.size(); ++i) {
            String key = (String)this.properties.keySet().toArray()[i];
            Object value = this.properties.get(key);
            stream.writeString(key);
            if (value instanceof String) {
                stream.writeByte(DataTypes.STRING.ordinal());
                stream.writeString((String)value);
            }
            if (value instanceof Integer) {
                stream.writeByte(DataTypes.INT.ordinal());
                stream.writeInt((Integer)value);
            }
            if (value instanceof Double) {
                stream.writeByte(DataTypes.DOUBLE.ordinal());
                stream.writeDouble((Double)value);
            }
            if (value instanceof Boolean) {
                stream.writeByte(DataTypes.BOOLEAN.ordinal());
                stream.writeBoolean((Boolean)value);
            }
            if (!(value instanceof CompoundTag)) continue;
            stream.writeByte(DataTypes.COMPOUND_TAG.ordinal());
            stream.writeCompoundTag((CompoundTag)value);
        }
    }

    public void readFromStream(IInputStream stream) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            String key = stream.readString();
            byte byteType = stream.readByte();
            DataTypes type = DataTypes.byId(byteType);
            if (type == null) {
                throw new IOException("Error loading skin properties " + byteType);
            }
            this.properties.put(key, switch (type.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> stream.readString();
                case 1 -> stream.readInt();
                case 2 -> stream.readDouble();
                case 3 -> stream.readBoolean();
                case 4 -> stream.readCompoundTag();
            });
        }
    }

    public SkinProperties slice(int index) {
        return new Stub(this, index);
    }

    public SkinProperties copy() {
        return new SkinProperties(new LinkedHashMap<String, Object>(this.properties));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.writeToNBT(tag);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinProperties)) {
            return false;
        }
        SkinProperties that = (SkinProperties)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return "SkinProperties [properties=" + String.valueOf(this.properties) + "]";
    }

    public void readFromNBT(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            Tag value = nbt.m_128423_(key);
            if (value instanceof StringTag) {
                this.properties.put(key, value.m_7916_());
                continue;
            }
            if (value instanceof IntTag) {
                this.properties.put(key, ((IntTag)value).m_7047_());
                continue;
            }
            if (value instanceof FloatTag) {
                this.properties.put(key, Float.valueOf(((FloatTag)value).m_7057_()));
                continue;
            }
            if (value instanceof DoubleTag) {
                this.properties.put(key, ((DoubleTag)value).m_7061_());
                continue;
            }
            if (!(value instanceof ByteTag)) continue;
            this.properties.put(key, ((ByteTag)value).m_7063_() != 0);
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        this.properties.forEach((key, value) -> {
            if (value instanceof String) {
                nbt.m_128359_(key, (String)value);
            } else if (value instanceof Integer) {
                nbt.m_128405_(key, ((Integer)value).intValue());
            } else if (value instanceof Float) {
                nbt.m_128347_(key, (double)((Float)value).floatValue());
            } else if (value instanceof Double) {
                nbt.m_128347_(key, ((Double)value).doubleValue());
            } else if (value instanceof Boolean) {
                nbt.m_128379_(key, ((Boolean)value).booleanValue());
            }
        });
    }

    public static enum DataTypes {
        STRING,
        INT,
        DOUBLE,
        BOOLEAN,
        COMPOUND_TAG;


        @Nullable
        public static DataTypes byId(int id) {
            if (id >= 0 & id < DataTypes.values().length) {
                return DataTypes.values()[id];
            }
            return null;
        }
    }

    public static class Stub
    extends SkinProperties {
        private final int index;

        public Stub(SkinProperties paranet, int index) {
            super(paranet.properties);
            this.index = index;
        }

        @Override
        public <T> void put(ISkinProperty<T> property, T value) {
            String indexedKey = this.getResolvedKey(property);
            if (indexedKey != null) {
                this.properties.put(indexedKey, value);
            } else {
                this.properties.put(property.getKey(), value);
            }
        }

        @Override
        public <T> void remove(ISkinProperty<T> property) {
            String indexedKey = this.getResolvedKey(property);
            if (indexedKey != null) {
                this.properties.remove(indexedKey);
            } else {
                this.properties.remove(property.getKey());
            }
        }

        @Override
        public <T> T get(ISkinProperty<T> property) {
            String indexedKey = this.getResolvedKey(property);
            T value = indexedKey != null && this.properties.containsKey(indexedKey) ? this.properties.getOrDefault(indexedKey, property.getDefaultValue()) : this.properties.getOrDefault(property.getKey(), property.getDefaultValue());
            return ObjectUtils.unsafeCast(value);
        }

        @Override
        public <T> boolean containsKey(ISkinProperty<T> property) {
            String indexedKey = this.getResolvedKey(property);
            if (indexedKey != null && this.properties.containsKey(indexedKey)) {
                return true;
            }
            return this.properties.containsKey(property.getKey());
        }

        @Override
        public <T> boolean containsValue(ISkinProperty<T> property) {
            String indexedKey = this.getResolvedKey(property);
            if (indexedKey != null && this.properties.containsValue(indexedKey)) {
                return true;
            }
            return this.properties.containsValue(property.getKey());
        }

        @Nullable
        private <T> String getResolvedKey(ISkinProperty<T> property) {
            SkinProperty property1;
            if (property instanceof SkinProperty && (property1 = (SkinProperty)property).isMultipleKey()) {
                return property.getKey() + this.index;
            }
            return null;
        }
    }

    public static class Changes
    extends SkinProperties {
        public Changes() {
        }

        public Changes(CompoundTag tag) {
            this.readFromNBT(tag);
        }

        @Override
        public <T> void put(ISkinProperty<T> property, T value) {
            this.properties.put(property.getKey(), value);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.writeToNBT(tag);
            return tag;
        }
    }
}

