/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer;

import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.exception.NewerFileVersionException;
import moe.plushie.armourers_workshop.core.skin.exception.UnsupportedFileFormatException;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.ISkinSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v12.SkinSerializerV12;
import moe.plushie.armourers_workshop.core.skin.serializer.v13.SkinSerializerV13;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.SkinSerializerV20;

public class SkinSerializer {
    private static final ImmutableList<ISkinSerializer> SERIALIZERS = ImmutableList.builder().add((Object)new SkinSerializerV20()).add((Object)new SkinSerializerV13()).add((Object)new SkinSerializerV12()).build();

    public static void writeToStream(Skin skin, DataOutputStream stream) throws IOException {
        int fileVersion = skin.getVersion();
        if (fileVersion >= 20) {
            fileVersion = 1397442894;
        }
        SkinSerializer.writeToStream(skin, stream, fileVersion);
    }

    public static void writeToStream(Skin skin, DataOutputStream stream, int fileVersion) throws IOException {
        for (ISkinSerializer serializer : SERIALIZERS) {
            if (!serializer.isSupportedVersion(fileVersion)) continue;
            stream.writeInt(serializer.getSupportedVersion());
            serializer.writeToStream(skin, IOutputStream.of(stream), fileVersion);
            return;
        }
        throw new UnsupportedFileFormatException();
    }

    public static Skin readSkinFromStream(DataInputStream stream) throws IOException, NewerFileVersionException, InvalidCubeTypeException {
        int fileVersion = stream.readInt();
        for (ISkinSerializer serializer : SERIALIZERS) {
            if (!serializer.isSupportedVersion(fileVersion)) continue;
            return serializer.readFromStream(IInputStream.of(stream), fileVersion);
        }
        throw new UnsupportedFileFormatException();
    }

    public static SkinFileHeader readSkinInfoFromStream(DataInputStream stream) throws IOException, NewerFileVersionException {
        int fileVersion = stream.readInt();
        for (ISkinSerializer impl : SERIALIZERS) {
            if (!impl.isSupportedVersion(fileVersion)) continue;
            return impl.readInfoFromStream(IInputStream.of(stream), fileVersion);
        }
        throw new NewerFileVersionException(fileVersion);
    }

    public static class Versions {
        public static final int V12 = 12;
        public static final int V13 = 13;
        public static final int V20 = 20;
    }
}

