/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.api.skin.ISkinDyeType;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;

public class SkinUsedCounter {
    private final Set<ISkinDyeType> dyeTypes = new HashSet<ISkinDyeType>();
    private final int[] cubeTotals = new int[SkinCubeTypes.getTotalCubes()];
    private int markerTotal;
    private int cubeTotal;
    private int faceTotal;

    public void add(SkinUsedCounter counter) {
        this.markerTotal += counter.markerTotal;
        this.cubeTotal += counter.cubeTotal;
        for (int i = 0; i < this.cubeTotals.length; ++i) {
            this.cubeTotals[i] = this.cubeTotals[i] + counter.cubeTotals[i];
        }
    }

    public void addCube(int cubeId) {
        ISkinCubeType cubeType = SkinCubeTypes.byId(cubeId);
        ++this.cubeTotal;
        int assignTransformLhsTemp44 = cubeType.getId();
        int cfr_ignored_0 = this.cubeTotals[assignTransformLhsTemp44] + 1;
    }

    public void addMarkers(int count) {
        this.markerTotal += count;
    }

    public void addPaints(Set<ISkinPaintType> paintTypes) {
        if (paintTypes == null) {
            return;
        }
        for (ISkinPaintType paintType : paintTypes) {
            if (paintType.getDyeType() == null) continue;
            this.dyeTypes.add(paintType.getDyeType());
        }
    }

    public void addFaceTotal(int total) {
        this.faceTotal += total;
    }

    public void reset() {
        this.dyeTypes.clear();
        this.markerTotal = 0;
        this.cubeTotal = 0;
        Arrays.fill(this.cubeTotals, 0);
    }

    public int getDyeTotal() {
        return this.dyeTypes.size();
    }

    public Set<ISkinDyeType> getDyeTypes() {
        return this.dyeTypes;
    }

    public int getMarkerTotal() {
        return this.markerTotal;
    }

    public int getCubeTotal(ISkinCubeType cube) {
        return this.cubeTotals[cube.getId()];
    }

    public int getCubeTotal() {
        return this.cubeTotal;
    }
}

