/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v12;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.ISkinSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v12.SkinPartSerializerV12;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;
import moe.plushie.armourers_workshop.init.ModLog;

public final class SkinSerializerV12
implements ISkinSerializer {
    public static final int FILE_VERSION = 12;
    private static final String TAG_SKIN_HEADER = "AW-SKIN-START";
    private static final String TAG_SKIN_PROPS_HEADER = "PROPS-START";
    private static final String TAG_SKIN_PROPS_FOOTER = "PROPS-END";
    private static final String TAG_SKIN_TYPE_HEADER = "TYPE-START";
    private static final String TAG_SKIN_TYPE_FOOTER = "TYPE-END";
    private static final String TAG_SKIN_PAINT_HEADER = "PAINT-START";
    private static final String TAG_SKIN_PAINT_FOOTER = "PAINT-END";
    private static final String TAG_SKIN_PART_HEADER = "PART-START";
    private static final String TAG_SKIN_PART_FOOTER = "PART-END";
    private static final String TAG_SKIN_FOOTER = "AW-SKIN-END";
    private final SkinPartSerializerV12 partSerializer = new SkinPartSerializerV12();

    public String getTypeNameByLegacyId(int legacyId) {
        return switch (legacyId) {
            case 0 -> "armourers:head";
            case 1 -> "armourers:chest";
            case 2 -> "armourers:legs";
            case 3 -> "armourers:skirt";
            case 4 -> "armourers:feet";
            case 5 -> "armourers:sword";
            case 6 -> "armourers:bow";
            case 7 -> "armourers:arrow";
            default -> null;
        };
    }

    @Override
    public void writeToStream(Skin skin, IOutputStream stream, int fileVersion) throws IOException {
        stream.writeString(TAG_SKIN_HEADER);
        stream.writeString(TAG_SKIN_PROPS_HEADER);
        stream.writeSkinProperties(skin.getProperties());
        stream.writeString(TAG_SKIN_PROPS_FOOTER);
        stream.writeString(TAG_SKIN_TYPE_HEADER);
        stream.writeType(skin.getType());
        stream.writeString(TAG_SKIN_TYPE_FOOTER);
        stream.writeString(TAG_SKIN_PAINT_HEADER);
        if (skin.getPaintData() != null) {
            stream.writeBoolean(true);
            int[] colors = skin.getPaintData().getData();
            for (int i = 0; i < 2048; ++i) {
                stream.writeInt(colors[i]);
            }
        } else {
            stream.writeBoolean(false);
        }
        stream.writeString(TAG_SKIN_PAINT_FOOTER);
        stream.writeByte(skin.getParts().size());
        for (SkinPart skinPart : skin.getParts()) {
            stream.writeString(TAG_SKIN_PART_HEADER);
            this.partSerializer.saveSkinPart(skinPart, stream);
            stream.writeString(TAG_SKIN_PART_FOOTER);
        }
        stream.writeString(TAG_SKIN_FOOTER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Skin readFromStream(IInputStream stream, int fileVersion) throws IOException, InvalidCubeTypeException {
        String footer;
        String typeFooter;
        int i;
        boolean hasPaintData;
        String typeFooter2;
        if (fileVersion > 12) {
            String propsHeader;
            String header = stream.readString();
            if (!header.equals(TAG_SKIN_HEADER)) {
                ModLog.error("Error loading skin header.", new Object[0]);
            }
            if (!(propsHeader = stream.readString()).equals(TAG_SKIN_PROPS_HEADER)) {
                ModLog.error("Error loading skin props header.", new Object[0]);
            }
        }
        SkinProperties properties = null;
        boolean loadedProps = true;
        IOException e = null;
        if (fileVersion < 12) {
            String authorName = stream.readString();
            String customName = stream.readString();
            String tags = "";
            if (fileVersion >= 4) {
                tags = stream.readString();
            }
            properties = new SkinProperties();
            properties.put(SkinProperty.ALL_AUTHOR_NAME, authorName);
            properties.put(SkinProperty.ALL_CUSTOM_NAME, customName);
            if (!tags.equalsIgnoreCase("")) {
                properties.put(SkinProperty.ALL_KEY_TAGS, tags);
            }
        } else {
            try {
                properties = stream.readSkinProperties();
            }
            catch (IOException propE) {
                ModLog.error("prop load failed", new Object[0]);
                e = propE;
                loadedProps = false;
                properties = new SkinProperties();
            }
        }
        if (fileVersion > 12) {
            String typeHeader;
            String propsFooter = stream.readString();
            if (!propsFooter.equals(TAG_SKIN_PROPS_FOOTER)) {
                ModLog.error("Error loading skin props footer.", new Object[0]);
            }
            if (!(typeHeader = stream.readString()).equals(TAG_SKIN_TYPE_HEADER)) {
                ModLog.error("Error loading skin type header.", new Object[0]);
            }
        }
        ISkinType skinType = null;
        if (fileVersion < 5) {
            if (!loadedProps) throw e;
            String regName = this.getTypeNameByLegacyId(stream.readByte() - 1);
            skinType = SkinTypes.byName(regName);
        } else if (loadedProps) {
            skinType = stream.readType(SkinTypes::byName);
        } else {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            } while (!sb.toString().endsWith("armourers:"));
            ModLog.info("Got armourers", new Object[0]);
            sb = new StringBuilder();
            sb.append("armourers:");
            while (SkinTypes.byName(sb.toString()) == null) {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            }
            ModLog.info(sb.toString(), new Object[0]);
            skinType = SkinTypes.byName(sb.toString());
            ModLog.info("got failed type " + String.valueOf(skinType), new Object[0]);
        }
        if (fileVersion > 12 && !(typeFooter2 = stream.readString()).equals(TAG_SKIN_TYPE_FOOTER)) {
            ModLog.error("Error loading skin type footer.", new Object[0]);
        }
        if (skinType == null) {
            throw new InvalidCubeTypeException();
        }
        if (fileVersion > 12 && !(typeFooter2 = stream.readString()).equals(TAG_SKIN_PAINT_HEADER)) {
            ModLog.error("Error loading skin paint header.", new Object[0]);
        }
        SkinPaintData paintData = null;
        if (fileVersion > 7 && (hasPaintData = stream.readBoolean())) {
            paintData = SkinPaintData.v1();
            int[] colors = paintData.getData();
            for (i = 0; i < 2048; ++i) {
                colors[i] = stream.readInt();
            }
        }
        if (fileVersion > 12 && !(typeFooter = stream.readString()).equals(TAG_SKIN_PAINT_FOOTER)) {
            ModLog.error("Error loading skin paint footer.", new Object[0]);
        }
        int size = stream.readByte();
        ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
        for (i = 0; i < size; ++i) {
            String partFooter;
            String partHeader;
            if (fileVersion > 12 && !(partHeader = stream.readString()).equals(TAG_SKIN_PART_HEADER)) {
                ModLog.error("Error loading skin part header.", new Object[0]);
            }
            SkinPart part = this.partSerializer.loadSkinPart(stream, fileVersion);
            if (fileVersion > 12 && !(partFooter = stream.readString()).equals(TAG_SKIN_PART_FOOTER)) {
                ModLog.error("Error loading skin part footer.", new Object[0]);
            }
            parts.add(part);
        }
        if (fileVersion > 12 && !(footer = stream.readString()).equals(TAG_SKIN_FOOTER)) {
            ModLog.error("Error loading skin footer.", new Object[0]);
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        builder.properties(properties);
        builder.paintData(paintData);
        builder.parts(parts);
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SkinFileHeader readInfoFromStream(IInputStream stream, int fileVersion) throws IOException {
        if (fileVersion > 12) {
            String propsHeader;
            String header = stream.readString();
            if (!header.equals(TAG_SKIN_HEADER)) {
                ModLog.error("Error loading skin header.", new Object[0]);
            }
            if (!(propsHeader = stream.readString()).equals(TAG_SKIN_PROPS_HEADER)) {
                ModLog.error("Error loading skin props header.", new Object[0]);
            }
        }
        SkinProperties properties = null;
        boolean loadedProps = true;
        IOException e = null;
        if (fileVersion < 12) {
            String authorName = stream.readString();
            String customName = stream.readString();
            String tags = "";
            tags = fileVersion >= 4 ? stream.readString() : "";
            properties = new SkinProperties();
            properties.put(SkinProperty.ALL_AUTHOR_NAME, authorName);
            properties.put(SkinProperty.ALL_CUSTOM_NAME, customName);
            if (!tags.equalsIgnoreCase("")) {
                properties.put(SkinProperty.ALL_KEY_TAGS, tags);
            }
        } else {
            try {
                properties = stream.readSkinProperties();
            }
            catch (IOException propE) {
                ModLog.error("prop load failed", new Object[0]);
                e = propE;
                loadedProps = false;
                properties = new SkinProperties();
            }
        }
        if (fileVersion > 12) {
            String typeHeader;
            String propsFooter = stream.readString();
            if (!propsFooter.equals(TAG_SKIN_PROPS_FOOTER)) {
                ModLog.error("Error loading skin props footer.", new Object[0]);
            }
            if (!(typeHeader = stream.readString()).equals(TAG_SKIN_TYPE_HEADER)) {
                ModLog.error("Error loading skin type header.", new Object[0]);
            }
        }
        ISkinType equipmentSkinType = null;
        if (fileVersion < 5) {
            if (!loadedProps) throw e;
            String regName = this.getTypeNameByLegacyId(stream.readByte() - 1);
            equipmentSkinType = SkinTypes.byName(regName);
            return SkinFileHeader.optimized(fileVersion, equipmentSkinType, properties);
        } else if (loadedProps) {
            equipmentSkinType = stream.readType(SkinTypes::byName);
            return SkinFileHeader.optimized(fileVersion, equipmentSkinType, properties);
        } else {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            } while (!sb.toString().endsWith("armourers:"));
            ModLog.info("Got armourers", new Object[0]);
            sb = new StringBuilder();
            sb.append("armourers:");
            while (SkinTypes.byName(sb.toString()) == null) {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            }
            ModLog.info(sb.toString(), new Object[0]);
            equipmentSkinType = SkinTypes.byName(sb.toString());
            ModLog.info("got failed type " + String.valueOf(equipmentSkinType), new Object[0]);
        }
        return SkinFileHeader.optimized(fileVersion, equipmentSkinType, properties);
    }

    @Override
    public int getSupportedVersion() {
        return 12;
    }

    @Override
    public boolean isSupportedVersion(int fileVersion) {
        return fileVersion <= 12;
    }
}

