/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v13;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.ISkinSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v13.SkinPartSerializerV13;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;
import moe.plushie.armourers_workshop.init.ModLog;

public final class SkinSerializerV13
implements ISkinSerializer {
    public static final int FILE_VERSION = 13;
    private static final String TAG_SKIN_HEADER = "AW-SKIN-START";
    private static final String TAG_SKIN_PROPS_HEADER = "PROPS-START";
    private static final String TAG_SKIN_PROPS_FOOTER = "PROPS-END";
    private static final String TAG_SKIN_TYPE_HEADER = "TYPE-START";
    private static final String TAG_SKIN_TYPE_FOOTER = "TYPE-END";
    private static final String TAG_SKIN_PAINT_HEADER = "PAINT-START";
    private static final String TAG_SKIN_PAINT_FOOTER = "PAINT-END";
    private static final String TAG_SKIN_PART_HEADER = "PART-START";
    private static final String TAG_SKIN_PART_FOOTER = "PART-END";
    private static final String TAG_SKIN_FOOTER = "AW-SKIN-END";
    private static final String KEY_TAGS = "tags";
    private SkinPartSerializerV13 partSerializer = new SkinPartSerializerV13();

    @Override
    public void writeToStream(Skin skin, IOutputStream stream, int fileVersion) throws IOException {
        stream.writeString(TAG_SKIN_HEADER);
        stream.writeString(TAG_SKIN_PROPS_HEADER);
        stream.writeSkinProperties(skin.getProperties());
        stream.writeString(TAG_SKIN_PROPS_FOOTER);
        stream.writeString(TAG_SKIN_TYPE_HEADER);
        stream.writeType(skin.getType());
        stream.writeString(TAG_SKIN_TYPE_FOOTER);
        stream.writeString(TAG_SKIN_PAINT_HEADER);
        if (skin.getPaintData() != null) {
            stream.writeBoolean(true);
            int[] colors = skin.getPaintData().getData();
            for (int i = 0; i < 2048; ++i) {
                stream.writeInt(colors[i]);
            }
        } else {
            stream.writeBoolean(false);
        }
        stream.writeString(TAG_SKIN_PAINT_FOOTER);
        stream.writeByte(skin.getParts().size());
        for (SkinPart skinPart : skin.getParts()) {
            stream.writeString(TAG_SKIN_PART_HEADER);
            this.partSerializer.saveSkinPart(skinPart, stream);
            stream.writeString(TAG_SKIN_PART_FOOTER);
        }
        stream.writeString(TAG_SKIN_FOOTER);
    }

    @Override
    public Skin readFromStream(IInputStream stream, int fileVersion) throws IOException, InvalidCubeTypeException {
        if (!stream.readString().equals(TAG_SKIN_HEADER)) {
            ModLog.error("Error loading skin header.", new Object[0]);
        }
        if (!stream.readString().equals(TAG_SKIN_PROPS_HEADER)) {
            ModLog.error("Error loading skin props header.", new Object[0]);
        }
        SkinProperties properties = null;
        boolean loadedProps = true;
        IOException e = null;
        try {
            properties = stream.readSkinProperties();
        }
        catch (IOException propE) {
            ModLog.error("prop load failed", new Object[0]);
            e = propE;
            loadedProps = false;
            properties = new SkinProperties();
        }
        if (!stream.readString().equals(TAG_SKIN_PROPS_FOOTER)) {
            ModLog.error("Error loading skin props footer.", new Object[0]);
        }
        if (!stream.readString().equals(TAG_SKIN_TYPE_HEADER)) {
            ModLog.error("Error loading skin type header.", new Object[0]);
        }
        ISkinType skinType = null;
        if (loadedProps) {
            String regName = stream.readString();
            skinType = SkinTypes.byName(regName);
        } else {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            } while (!sb.toString().endsWith("armourers:"));
            ModLog.info("Got armourers", new Object[0]);
            sb = new StringBuilder();
            sb.append("armourers:");
            while (SkinTypes.byName(sb.toString()) == null) {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            }
            ModLog.info(sb.toString(), new Object[0]);
            skinType = SkinTypes.byName(sb.toString());
            ModLog.info("got failed type " + String.valueOf(skinType), new Object[0]);
        }
        if (!stream.readString().equals(TAG_SKIN_TYPE_FOOTER)) {
            ModLog.error("Error loading skin type footer.", new Object[0]);
        }
        if (skinType == null) {
            throw new InvalidCubeTypeException();
        }
        if (!stream.readString().equals(TAG_SKIN_PAINT_HEADER)) {
            ModLog.error("Error loading skin paint header.", new Object[0]);
        }
        SkinPaintData paintData = null;
        boolean hasPaintData = stream.readBoolean();
        if (hasPaintData) {
            paintData = SkinPaintData.v1();
            int[] colors = paintData.getData();
            for (int i = 0; i < 2048; ++i) {
                colors[i] = stream.readInt();
            }
        }
        if (!stream.readString().equals(TAG_SKIN_PAINT_FOOTER)) {
            ModLog.error("Error loading skin paint footer.", new Object[0]);
        }
        int size = stream.readByte();
        ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
        for (int i = 0; i < size; ++i) {
            if (!stream.readString().equals(TAG_SKIN_PART_HEADER)) {
                ModLog.error("Error loading skin part header.", new Object[0]);
            }
            SkinPart part = this.partSerializer.loadSkinPart(stream, fileVersion);
            parts.add(part);
            if (stream.readString().equals(TAG_SKIN_PART_FOOTER)) continue;
            ModLog.error("Error loading skin part footer.", new Object[0]);
        }
        if (!stream.readString().equals(TAG_SKIN_FOOTER)) {
            ModLog.error("Error loading skin footer.", new Object[0]);
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        builder.properties(properties);
        builder.paintData(paintData);
        builder.parts(parts);
        return builder.build();
    }

    @Override
    public SkinFileHeader readInfoFromStream(IInputStream stream, int fileVersion) throws IOException {
        if (!stream.readString().equals(TAG_SKIN_HEADER)) {
            ModLog.error("Error loading skin header.", new Object[0]);
        }
        if (!stream.readString().equals(TAG_SKIN_PROPS_HEADER)) {
            ModLog.error("Error loading skin props header.", new Object[0]);
        }
        SkinProperties properties = null;
        boolean loadedProps = true;
        IOException e = null;
        try {
            properties = stream.readSkinProperties();
        }
        catch (IOException propE) {
            ModLog.error("prop load failed", new Object[0]);
            e = propE;
            loadedProps = false;
            properties = new SkinProperties();
        }
        if (!stream.readString().equals(TAG_SKIN_PROPS_FOOTER)) {
            ModLog.error("Error loading skin props footer.", new Object[0]);
        }
        if (!stream.readString().equals(TAG_SKIN_TYPE_HEADER)) {
            ModLog.error("Error loading skin type header.", new Object[0]);
        }
        ISkinType skinType = null;
        if (loadedProps) {
            String regName = stream.readString();
            skinType = SkinTypes.byName(regName);
        } else {
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            } while (!sb.toString().endsWith("armourers:"));
            ModLog.info("Got armourers", new Object[0]);
            sb = new StringBuilder();
            sb.append("armourers:");
            while (SkinTypes.byName(sb.toString()) == null) {
                sb.append(new String(new byte[]{stream.readByte()}, StandardCharsets.UTF_8));
            }
            ModLog.info(sb.toString(), new Object[0]);
            skinType = SkinTypes.byName(sb.toString());
            ModLog.info("got failed type " + String.valueOf(skinType), new Object[0]);
        }
        return SkinFileHeader.optimized(fileVersion, skinType, properties);
    }

    @Override
    public int getSupportedVersion() {
        return 13;
    }
}

