/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkAnimationData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaintData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPartData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPreviewData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkType;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.texture.SkinPreviewData;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkSerializers {
    public static final ChunkSerializer<Skin, Void> SKIN = ChunkSerializers.register(new ChunkSerializer<Skin, Void>(ChunkType.SKIN){

        @Override
        public Skin read(ChunkInputStream stream, String name, Void obj) throws IOException {
            int version = stream.getContext().getVersion();
            ISkinType skinType = stream.readType(SkinTypes::byName);
            return stream.readChunk(it -> {
                ChunkPaletteData palette = it.read(SKIN_TEXTURE_DATA);
                ChunkCubeData chunkCubes = it.read(SKIN_CUBE_DATA, palette);
                Skin.Builder builder = new Skin.Builder(skinType);
                builder.properties(it.read(SKIN_PROPERTIES));
                builder.settings(it.read(SKIN_SETTINGS));
                builder.paintData(it.read(SKIN_PAINT_DATA, palette));
                builder.previewData(it.read(SKIN_PREVIEW_DATA, chunkCubes));
                builder.parts(it.read(SKIN_PART, chunkCubes));
                builder.animations(it.read(SKIN_ANIMATION_DATA));
                builder.blobs(it.readBlobs());
                builder.version(version);
                return builder.build();
            });
        }

        @Override
        public void write(Skin skin, Void obj, ChunkOutputStream stream) throws IOException {
            ChunkContext context = stream.getContext();
            stream.writeType(skin.getType());
            stream.writeChunk(it -> {
                ChunkPaletteData palette = new ChunkPaletteData();
                ChunkCubeData chunkCubes = new ChunkCubeData(palette);
                it.write(SKIN_PROPERTIES, skin.getProperties());
                it.write(SKIN_SETTINGS, skin.getSettings());
                it.write(SKIN_TEXTURE_DATA, palette);
                it.write(SKIN_PAINT_DATA, skin.getPaintData(), palette);
                it.write(SKIN_CUBE_DATA, chunkCubes, palette);
                it.write(SKIN_ANIMATION_DATA, skin.getAnimations());
                if (context.isEnablePartData()) {
                    it.write(SKIN_PART, skin.getParts(), chunkCubes);
                }
                if (context.isEnablePreviewData()) {
                    it.write(SKIN_PREVIEW_DATA, SkinPreviewData.of(skin), chunkCubes);
                }
                it.writeBlobs(skin.getBlobs());
            });
        }
    });
    public static final ChunkSerializer<Pair<ISkinType, ISkinProperties>, Void> SKIN_INFO = ChunkSerializers.register(new ChunkSerializer<Pair<ISkinType, ISkinProperties>, Void>(ChunkType.SKIN){

        @Override
        public Pair<ISkinType, ISkinProperties> read(ChunkInputStream stream, String name, Void obj) throws IOException {
            ISkinType skinType = stream.readType(SkinTypes::byName);
            return stream.readChunk(it -> {
                SkinProperties properties = it.read(SKIN_PROPERTIES);
                return Pair.of((Object)skinType, (Object)properties);
            });
        }

        @Override
        public void write(Pair<ISkinType, ISkinProperties> info, Void obj, ChunkOutputStream stream) throws IOException {
        }
    });
    public static final ChunkSerializer<Collection<SkinPart>, ChunkCubeData> SKIN_PART = ChunkSerializers.register(new ChunkSerializer<Collection<SkinPart>, ChunkCubeData>(ChunkType.SKIN_PART){

        @Override
        public Collection<SkinPart> read(ChunkInputStream stream, String name, ChunkCubeData chunkCubes) throws IOException {
            ChunkPartData partData = new ChunkPartData(chunkCubes);
            return partData.readFromStream(stream, (it, builder) -> {
                builder.markers(it.read(SKIN_MARKERS));
                builder.blobs(it.readBlobs());
            });
        }

        @Override
        public void write(Collection<SkinPart> parts, ChunkCubeData chunkCubes, ChunkOutputStream stream) throws IOException {
            ChunkPartData partData = new ChunkPartData(chunkCubes);
            partData.writeToStream(stream, parts, (it, part) -> {
                it.write(SKIN_MARKERS, part.getMarkers());
                it.writeBlobs(part.getBlobs());
            });
        }
    });
    public static final ChunkSerializer<Collection<SkinMarker>, Void> SKIN_MARKERS = ChunkSerializers.register(new ChunkSerializer<Collection<SkinMarker>, Void>(ChunkType.MARKER){

        @Override
        public Collection<SkinMarker> read(ChunkInputStream stream, String name, Void obj) throws IOException {
            int size = stream.readInt();
            ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
            for (int i = 0; i < size; ++i) {
                markers.add(new SkinMarker(stream));
            }
            return markers;
        }

        @Override
        public void write(Collection<SkinMarker> value, Void obj, ChunkOutputStream stream) throws IOException {
            stream.writeInt(value.size());
            for (SkinMarker marker : value) {
                marker.writeToStream(stream);
            }
        }
    });
    public static final ChunkSerializer<ChunkCubeData, ChunkPaletteData> SKIN_CUBE_DATA = ChunkSerializers.register(new ChunkSerializer<ChunkCubeData, ChunkPaletteData>(ChunkType.CUBE_DATA){

        @Override
        public ChunkCubeData read(ChunkInputStream stream, String name, ChunkPaletteData palette) throws IOException {
            ChunkCubeData chunkCubes = new ChunkCubeData(palette);
            chunkCubes.readFromStream(stream);
            return chunkCubes;
        }

        @Override
        public void write(ChunkCubeData chunkCubes, ChunkPaletteData palette, ChunkOutputStream stream) throws IOException {
            stream.writeVariable(chunkCubes);
        }
    });
    public static final ChunkSerializer<SkinPaintData, ChunkPaletteData> SKIN_PAINT_DATA = ChunkSerializers.register(new ChunkSerializer<SkinPaintData, ChunkPaletteData>(ChunkType.PAINT_DATA){

        @Override
        public SkinPaintData read(ChunkInputStream stream, String name, ChunkPaletteData palette) throws IOException {
            ChunkPaintData chunkPaintData = new ChunkPaintData(palette);
            return chunkPaintData.readFromStream(stream);
        }

        @Override
        public void write(SkinPaintData value, ChunkPaletteData palette, ChunkOutputStream stream) throws IOException {
            ChunkPaintData chunkPaintData = new ChunkPaintData(palette);
            chunkPaintData.writeToStream(value, stream);
        }
    });
    public static final ChunkSerializer<SkinPreviewData, ChunkCubeData> SKIN_PREVIEW_DATA = ChunkSerializers.register(new ChunkSerializer<SkinPreviewData, ChunkCubeData>(ChunkType.PREVIEW_DATA){

        @Override
        public SkinPreviewData read(ChunkInputStream stream, String name, ChunkCubeData chunkCubes) throws IOException {
            ChunkPreviewData chunkPreviewData = new ChunkPreviewData(chunkCubes);
            return chunkPreviewData.readFromStream(stream);
        }

        @Override
        public void write(SkinPreviewData previewData, ChunkCubeData chunkCubes, ChunkOutputStream stream) throws IOException {
            ChunkPreviewData chunkPreviewData = new ChunkPreviewData(chunkCubes);
            chunkPreviewData.writeToStream(previewData, stream);
        }
    });
    public static final ChunkSerializer<ChunkPaletteData, Void> SKIN_TEXTURE_DATA = ChunkSerializers.register(new ChunkSerializer<ChunkPaletteData, Void>(ChunkType.PALETTE){

        @Override
        public ChunkPaletteData read(ChunkInputStream stream, String name, Void obj) throws IOException {
            ChunkPaletteData palette = new ChunkPaletteData();
            palette.readFromStream(stream);
            return palette;
        }

        @Override
        public void write(ChunkPaletteData value, Void obj, ChunkOutputStream stream) throws IOException {
            stream.writeVariable(value);
        }
    });
    public static final ChunkSerializer<List<SkinAnimation>, Void> SKIN_ANIMATION_DATA = ChunkSerializers.register(new ChunkSerializer<List<SkinAnimation>, Void>(ChunkType.ANIMATION_DATA){

        @Override
        public List<SkinAnimation> read(ChunkInputStream stream, String name, Void obj) throws IOException {
            ChunkAnimationData animationData = new ChunkAnimationData();
            return animationData.readFromStream(stream);
        }

        @Override
        public void write(List<SkinAnimation> value, Void obj, ChunkOutputStream stream) throws IOException {
            ChunkAnimationData animationData = new ChunkAnimationData();
            animationData.writeToStream(value, stream);
        }
    });
    public static final ChunkSerializer<SkinProperties, Void> SKIN_PROPERTIES = ChunkSerializers.register(new ChunkSerializer<SkinProperties, Void>(ChunkType.PROPERTIES){

        @Override
        public SkinProperties read(ChunkInputStream stream, String name, Void obj) throws IOException {
            SkinProperties properties = new SkinProperties();
            properties.readFromStream(stream);
            return properties;
        }

        @Override
        public void write(SkinProperties value, Void obj, ChunkOutputStream stream) throws IOException {
            value.writeToStream(stream);
        }

        @Override
        public boolean canWrite(SkinProperties value, Void obj, ChunkOutputStream stream) {
            return !value.isEmpty();
        }
    });
    public static final ChunkSerializer<SkinSettings, Void> SKIN_SETTINGS = ChunkSerializers.register(new ChunkSerializer<SkinSettings, Void>(ChunkType.SKIN_SETTINGS){

        @Override
        public SkinSettings read(ChunkInputStream stream, String name, Void obj) throws IOException {
            SkinSettings settings = new SkinSettings();
            if (name.equals("SET2")) {
                settings.readFromLegacyStream(stream);
            } else {
                settings.readFromStream(stream);
            }
            return settings;
        }

        @Override
        public boolean canRead(String name) {
            return super.canRead(name) || name.equals("SET2");
        }

        @Override
        public void write(SkinSettings value, Void obj, ChunkOutputStream stream) throws IOException {
            value.writeToStream(stream);
        }

        @Override
        public boolean canWrite(SkinSettings value, Void obj, ChunkOutputStream stream) {
            return !value.isEmpty();
        }
    });

    public static void writeToStream(Skin skin, IOutputStream stream, ChunkContext context) throws IOException {
        ChunkOutputStream stream1 = new ChunkOutputStream(context);
        SKIN.write(skin, null, stream1);
        stream1.transferTo(stream.getOutputStream());
    }

    public static Skin readFromStream(IInputStream stream, ChunkContext context) throws IOException {
        ChunkInputStream stream1 = new ChunkInputStream(stream.getInputStream(), context, null);
        return SKIN.read(stream1, "", null);
    }

    public static Pair<ISkinType, ISkinProperties> readInfoFromStream(IInputStream stream, ChunkContext context) throws IOException {
        ArrayList allows = Lists.newArrayList((Object[])new String[]{ChunkType.PROPERTIES.getName()});
        ChunkInputStream stream1 = new ChunkInputStream(stream.getInputStream(), context, allows::contains);
        return SKIN_INFO.read(stream1, "", null);
    }

    private static <T, C> ChunkSerializer<T, C> register(ChunkSerializer<T, C> serializer) {
        return serializer;
    }
}

