/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationValue;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkAnimationData {
    public List<SkinAnimation> readFromStream(IInputStream stream) throws IOException {
        ArrayList<SkinAnimation> results = new ArrayList<SkinAnimation>();
        int count = stream.readVarInt();
        for (int i = 0; i < count; ++i) {
            Section section = this.readSectionFromStream(stream);
            results.add(section.animation);
        }
        return results;
    }

    public void writeToStream(List<SkinAnimation> animations, IOutputStream stream) throws IOException {
        stream.writeVarInt(animations.size());
        for (SkinAnimation animation : animations) {
            Section section = new Section(animation);
            this.writeSectionToStream(section, stream);
        }
    }

    private Section readSectionFromStream(IInputStream stream) throws IOException {
        String id = stream.readString();
        float duration = stream.readFloat();
        SkinAnimationLoop loop = stream.readEnum(SkinAnimationLoop.class);
        Section section = new Section(id, duration, loop);
        section.readFromStream(stream);
        return section;
    }

    private void writeSectionToStream(Section section, IOutputStream stream) throws IOException {
        stream.writeString(section.id);
        stream.writeFloat(section.duration);
        stream.writeEnum(section.loop);
        section.writeToStream(stream);
    }

    public static class Section {
        private SkinAnimation animation;
        private final String id;
        private final float duration;
        private final SkinAnimationLoop loop;

        public Section(String id, float duration, SkinAnimationLoop loop) {
            this.id = id;
            this.loop = loop;
            this.duration = duration;
        }

        public Section(SkinAnimation animation) {
            this.id = animation.getName();
            this.loop = animation.getLoop();
            this.duration = animation.getDuration();
            this.animation = animation;
        }

        void readFromStream(IInputStream stream) throws IOException {
            int count;
            LinkedHashMap<String, List<SkinAnimationValue>> values = new LinkedHashMap<String, List<SkinAnimationValue>>();
            while ((count = stream.readVarInt()) != 0) {
                String bone = stream.readString();
                String channel = stream.readString();
                for (int i = 0; i < count; ++i) {
                    SkinAnimationValue value = SkinAnimationValue.readFromStream(channel, stream);
                    values.computeIfAbsent(bone, k -> new ArrayList()).add(value);
                }
            }
            this.animation = new SkinAnimation(this.id, this.duration, this.loop, values);
        }

        void writeToStream(IOutputStream stream) throws IOException {
            LinkedHashMap channels = new LinkedHashMap();
            this.animation.getValues().forEach((bone, values) -> values.forEach(value -> {
                Pair key = Pair.of((Object)bone, (Object)value.getKey());
                channels.computeIfAbsent(key, k -> new ArrayList()).add(value);
            }));
            for (Map.Entry entry : channels.entrySet()) {
                String bone2 = (String)((Pair)entry.getKey()).getKey();
                String channel = (String)((Pair)entry.getKey()).getValue();
                ArrayList values2 = (ArrayList)entry.getValue();
                stream.writeVarInt(values2.size());
                stream.writeString(bone2);
                stream.writeString(channel);
                for (SkinAnimationValue value : values2) {
                    value.writeToStream(channel, stream);
                }
            }
            stream.writeVarInt(0);
        }

        public boolean isEmpty() {
            return this.animation != null && this.animation.getValues().isEmpty();
        }
    }
}

