/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.texture.TextureAnimation;
import moe.plushie.armourers_workshop.core.texture.TextureData;
import moe.plushie.armourers_workshop.core.texture.TextureOptions;
import moe.plushie.armourers_workshop.core.texture.TextureProperties;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Vector2f;

public abstract class ChunkColorSection {
    private static final byte[] BUFFER = new byte[8];
    protected int index = 0;
    protected int size = 0;
    protected int colorIndexBytes = 1;
    protected int textureIndexBytes = 4;
    protected boolean resolved = false;
    protected final int usedBytes;
    protected final ISkinPaintType paintType;

    public ChunkColorSection(int count, int colorBytes, ISkinPaintType paintType) {
        this.size = count;
        this.usedBytes = colorBytes;
        this.paintType = paintType;
    }

    public abstract void writeToStream(IOutputStream var1) throws IOException;

    public void freeze(int index) {
        this.index = index;
        this.resolved = true;
    }

    public void freezeIndex(int colorUsedIndex, int textureUsedIndex) {
        this.colorIndexBytes = colorUsedIndex;
        this.textureIndexBytes = textureUsedIndex;
    }

    public abstract IPaintColor getColor(int var1);

    public TextureRef getTexture(Vector2f pos) {
        TextureList list = this.getTextureList(pos);
        if (list != null) {
            return list.get(pos, this);
        }
        return null;
    }

    protected abstract TextureList getTextureList(Vector2f var1);

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isTexture() {
        return this.usedBytes == 0;
    }

    public int getStartIndex() {
        return this.index;
    }

    public int getEndIndex() {
        return this.index + this.size;
    }

    public int getSize() {
        return this.size;
    }

    public int getUsedBytes() {
        return this.usedBytes;
    }

    public ISkinPaintType getPaintType() {
        return this.paintType;
    }

    private static int _readFixedInt(int usedBytes, IInputStream stream) throws IOException {
        stream.read(BUFFER, 0, usedBytes);
        return ChunkColorSection._readFixedInt(usedBytes, 0, BUFFER);
    }

    private static int _readFixedInt(int usedBytes, int offset, byte[] bytes) {
        int value = 0;
        for (int i = 0; i < usedBytes; ++i) {
            value = value << 8 | bytes[offset + i] & 0xFF;
        }
        return value;
    }

    private static void _writeFixedInt(int value, int usedBytes, IOutputStream stream) throws IOException {
        if (usedBytes == 4) {
            stream.writeInt(value);
            return;
        }
        ChunkColorSection.BUFFER[0] = (byte)(value >>> 24);
        ChunkColorSection.BUFFER[1] = (byte)(value >>> 16);
        ChunkColorSection.BUFFER[2] = (byte)(value >>> 8);
        ChunkColorSection.BUFFER[3] = (byte)(value >>> 0);
        stream.write(BUFFER, 4 - usedBytes, usedBytes);
    }

    private static float _readFixedFloat(int usedBytes, int offset, byte[] bytes) {
        return Float.intBitsToFloat(ChunkColorSection._readFixedInt(usedBytes, offset, bytes));
    }

    private static void _writeFixedFloat(float value, int usedBytes, IOutputStream stream) throws IOException {
        ChunkColorSection._writeFixedInt(Float.floatToIntBits(value), usedBytes, stream);
    }

    public static class TextureList {
        protected TextureList proxy;
        private Rectangle2f rect = Rectangle2f.ZERO;
        private ITextureProvider provider;
        private boolean isResolved = false;
        protected int id = 0;
        protected int parentId = 0;
        private final ArrayList<TextureRef> uvs = new ArrayList();

        public TextureList() {
        }

        public TextureList(ITextureProvider provider) {
            this.rect = new Rectangle2f(0.0f, 0.0f, provider.getWidth(), provider.getHeight());
            this.provider = provider;
        }

        public void readFromStream(IInputStream stream) throws IOException {
            if (this.proxy != null) {
                return;
            }
            this.id = stream.readVarInt();
            this.parentId = stream.readVarInt();
            float x = stream.readFloat();
            float y = stream.readFloat();
            float width = stream.readFloat();
            float height = stream.readFloat();
            this.rect = new Rectangle2f(x, y, width, height);
            TextureAnimation animation = stream.readTextureAnimation();
            TextureProperties properties = stream.readTextureProperties();
            int byteSize = stream.readInt();
            TextureData provider = new TextureData(String.valueOf(this.id), width, height, animation, properties);
            provider.load(stream.readBytes(byteSize));
            this.provider = provider;
        }

        public void writeToStream(IOutputStream stream) throws IOException {
            if (this.proxy != null) {
                return;
            }
            ByteBuffer buffer = this.provider.getBuffer();
            stream.writeVarInt(this.id);
            stream.writeVarInt(this.parentId);
            stream.writeFloat(this.rect.getX());
            stream.writeFloat(this.rect.getY());
            stream.writeFloat(this.rect.getWidth());
            stream.writeFloat(this.rect.getHeight());
            stream.writeTextureAnimation((TextureAnimation)this.provider.getAnimation());
            stream.writeTextureProperties((TextureProperties)this.provider.getProperties());
            stream.writeInt(buffer.remaining());
            stream.writeBytes(buffer);
        }

        public void freeze(float x, float y, Function<ITextureProvider, TextureList> childProvider) {
            this.rect = new Rectangle2f(x, y, this.rect.getWidth(), this.rect.getHeight());
            this.isResolved = true;
            this.provider.getVariants().stream().map(childProvider).filter(Objects::nonNull).forEach(it -> {
                it.parentId = this.id;
            });
        }

        public boolean contains(Vector2f uv) {
            if (this.proxy != null) {
                return this.proxy.contains(uv);
            }
            float x0 = this.rect.getMinX();
            float x1 = uv.getX();
            float x2 = this.rect.getMaxX();
            return x0 <= x1 && x1 <= x2;
        }

        public TextureRef get(Vector2f uv, ChunkColorSection section) {
            if (this.proxy != null) {
                return this.proxy.get(uv, section);
            }
            return new TextureRef(section, this, new Vector2f(uv.getX() - this.rect.getX(), uv.getY()));
        }

        public TextureRef add(Vector2f uv, ChunkColorSection section) {
            if (this.proxy != null) {
                return this.proxy.add(uv, section);
            }
            TextureRef ref = new TextureRef(section, this, uv);
            this.uvs.add(ref);
            return ref;
        }

        public Rectangle2f getRect() {
            if (this.proxy != null) {
                return this.proxy.getRect();
            }
            return this.rect;
        }

        public boolean isProxy() {
            return this.proxy != null;
        }

        public boolean isResolved() {
            if (this.proxy != null) {
                return this.proxy.isResolved();
            }
            return this.isResolved;
        }
    }

    public static class TextureRef
    implements ChunkVariable {
        private final Vector2f uv;
        private final TextureList list;
        private final ChunkColorSection section;

        public TextureRef(ChunkColorSection section, TextureList list, Vector2f uv) {
            this.section = section;
            this.list = list;
            this.uv = uv;
        }

        public static Vector2f readFromStream(int usedIndexBytes, int offset, byte[] bytes) {
            float x = ChunkColorSection._readFixedFloat(usedIndexBytes, offset, bytes);
            float y = ChunkColorSection._readFixedFloat(usedIndexBytes, offset + usedIndexBytes, bytes);
            if (x == 0.0f && y == 0.0f) {
                return Vector2f.ZERO;
            }
            return new Vector2f(x, y);
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            Rectangle2f rect = this.list.getRect();
            ChunkColorSection._writeFixedFloat(rect.getX() + this.uv.getX(), this.section.textureIndexBytes, stream);
            ChunkColorSection._writeFixedFloat(rect.getY() + this.uv.getY(), this.section.textureIndexBytes, stream);
        }

        @Override
        public boolean freeze() {
            return this.section.isResolved() && this.list.isResolved();
        }

        public float getU() {
            return this.uv.getX();
        }

        public float getV() {
            return this.uv.getY();
        }

        public Vector2f getPos() {
            return this.uv;
        }

        public ITextureProvider getProvider() {
            return this.list.provider;
        }
    }

    public static class OptionsRef
    implements ChunkVariable {
        private final TextureOptions textureOptions;
        private final ChunkColorSection section;

        public OptionsRef(ChunkColorSection section, TextureOptions options) {
            this.section = section;
            this.textureOptions = options;
        }

        public static TextureOptions readFromStream(int usedIndexBytes, int offset, byte[] bytes) {
            int x = ChunkColorSection._readFixedInt(usedIndexBytes, offset, bytes);
            int y = ChunkColorSection._readFixedInt(usedIndexBytes, offset + usedIndexBytes, bytes);
            return new TextureOptions((long)y << 32 | (long)x);
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            long value = this.textureOptions.asLong();
            ChunkColorSection._writeFixedInt((int)value, this.section.textureIndexBytes, stream);
            ChunkColorSection._writeFixedInt((int)(value >> 32), this.section.textureIndexBytes, stream);
        }

        @Override
        public boolean freeze() {
            return this.section.isResolved();
        }
    }

    public static class ColorRef
    implements ChunkVariable {
        private final int value;
        private final ChunkColorSection section;

        public ColorRef(ChunkColorSection section, int value) {
            this.value = value;
            this.section = section;
        }

        public static int readFromStream(int usedIndexBytes, IInputStream stream) throws IOException {
            return ChunkColorSection._readFixedInt(usedIndexBytes, stream);
        }

        public static int readFromStream(int usedIndexBytes, int offset, byte[] bytes) {
            return ChunkColorSection._readFixedInt(usedIndexBytes, offset, bytes);
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            ChunkColorSection._writeFixedInt(this.section.getStartIndex() + this.value, this.section.colorIndexBytes, stream);
        }

        @Override
        public boolean freeze() {
            return this.section.isResolved();
        }
    }

    public static class Mutable
    extends ChunkColorSection {
        private final ArrayList<Integer> colorLists = new ArrayList();
        private final LinkedHashMap<Integer, ColorRef> indexes = new LinkedHashMap();
        private final LinkedHashMap<ITextureProvider, TextureList> textureLists = new LinkedHashMap();

        public Mutable(int colorBytes, ISkinPaintType paintType) {
            super(0, colorBytes, paintType);
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            Iterator<Object> iterator = this.colorLists.iterator();
            while (iterator.hasNext()) {
                int color = iterator.next();
                ChunkColorSection._writeFixedInt(color, this.usedBytes, stream);
            }
            for (TextureList list : this.textureLists.values()) {
                list.writeToStream(stream);
            }
        }

        @Override
        public void freeze(int index) {
            float x = 0.0f;
            float y = 0.0f;
            for (TextureList list : this.textureLists.values()) {
                list.freeze(x, y, this.textureLists::get);
                x += list.rect.getWidth() * 2.0f;
            }
            this.size = this.colorLists.size() + this.textureLists.size();
            super.freeze(index);
        }

        @Override
        public IPaintColor getColor(int offset) {
            int value = this.colorLists.get(offset);
            return PaintColor.of(value, this.getPaintType());
        }

        public ColorRef putColor(int value) {
            if (this.usedBytes == 3) {
                value |= 0xFF000000;
            }
            return this.indexes.computeIfAbsent(value, k -> {
                ColorRef ref = new ColorRef(this, this.colorLists.size());
                this.colorLists.add((Integer)k);
                return ref;
            });
        }

        public TextureRef putTexture(Vector2f uv, ITextureProvider provider) {
            TextureList textureList = this.getOrCreateTextureList(provider);
            ObjectUtils.search(provider.getVariants(), ITextureProvider::getVariants, this::getOrCreateTextureList);
            return textureList.add(uv, this);
        }

        public OptionsRef putTextureOptions(TextureOptions options) {
            return new OptionsRef(this, options);
        }

        @Override
        protected TextureList getTextureList(Vector2f pos) {
            for (TextureList list : this.textureLists.values()) {
                if (!list.contains(pos)) continue;
                return list;
            }
            return null;
        }

        protected TextureList getOrCreateTextureList(ITextureProvider provider) {
            return this.textureLists.computeIfAbsent(provider, it -> {
                TextureList list = new TextureList((ITextureProvider)it);
                list.id = this.textureLists.size() + 1;
                return list;
            });
        }
    }

    public static class Immutable
    extends ChunkColorSection {
        private byte[] buffers;
        private TextureList[] textureLists;

        public Immutable(int total, int usedBytes, ISkinPaintType paintType) {
            super(total, usedBytes, paintType);
        }

        public void readFromStream(IInputStream stream) throws IOException {
            if (this.usedBytes != 0) {
                this.buffers = new byte[this.usedBytes * this.size];
                stream.read(this.buffers);
            }
            if (this.isTexture()) {
                this.textureLists = new TextureList[this.size];
                for (int i = 0; i < this.size; ++i) {
                    TextureList list = new TextureList();
                    list.readFromStream(stream);
                    this.textureLists[i] = list;
                }
                for (TextureList parent : this.textureLists) {
                    ArrayList<ITextureProvider> variants = new ArrayList<ITextureProvider>(parent.provider.getVariants());
                    for (TextureList child : this.textureLists) {
                        if (parent.id != child.parentId) continue;
                        variants.add(child.provider);
                    }
                    ITextureProvider iTextureProvider = parent.provider;
                    if (!(iTextureProvider instanceof TextureData)) continue;
                    TextureData textureData = (TextureData)iTextureProvider;
                    textureData.setVariants(variants);
                }
            }
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            if (this.buffers != null) {
                stream.write(this.buffers);
            }
            if (this.textureLists != null) {
                for (TextureList list : this.textureLists) {
                    list.writeToStream(stream);
                }
            }
        }

        @Override
        public IPaintColor getColor(int offset) {
            int value = 0;
            for (int i = 0; i < this.usedBytes; ++i) {
                value = value << 8 | this.buffers[offset * this.usedBytes + i] & 0xFF;
            }
            return PaintColor.of(value, this.getPaintType());
        }

        @Override
        public TextureList getTextureList(Vector2f pos) {
            if (this.textureLists == null) {
                return null;
            }
            for (TextureList list : this.textureLists) {
                if (!list.contains(pos)) continue;
                return list;
            }
            return null;
        }
    }
}

