/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlag;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;

public class ChunkContext {
    public byte[] securityKey = null;
    public boolean enablePartData = true;
    public boolean enablePreviewData = false;
    private boolean allowsFastEncoder = true;
    private final int fileVersion;

    public ChunkContext(int fileVersion) {
        this.fileVersion = fileVersion;
    }

    public InputStream createInputStream(ByteBuf buf, ChunkFlags flags) throws IOException {
        Object inputStream = new ByteBufInputStream(buf);
        if (flags.contains(ChunkFlag.ENCRYPT)) {
            if (this.securityKey == null || this.securityKey.length == 0) {
                throw new IOException("missing security key!!");
            }
            try {
                SecretKeySpec key = new SecretKeySpec(this.securityKey, "AES");
                Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                aes.init(2, key);
                inputStream = new CipherInputStream((InputStream)inputStream, aes);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (flags.contains(ChunkFlag.GZIP)) {
            inputStream = new GZIPInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    public OutputStream createOutputStream(ByteBuf buf, ChunkFlags flags) throws IOException {
        Object outputStream = new ByteBufOutputStream(buf);
        if (flags.contains(ChunkFlag.ENCRYPT)) {
            if (this.securityKey == null || this.securityKey.length == 0) {
                throw new IOException("missing security key!!");
            }
            try {
                SecretKeySpec key = new SecretKeySpec(this.securityKey, "AES");
                Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                aes.init(1, key);
                outputStream = new CipherOutputStream((OutputStream)outputStream, aes);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        if (flags.contains(ChunkFlag.GZIP)) {
            outputStream = new GZIPOutputStream((OutputStream)outputStream);
        }
        return outputStream;
    }

    public boolean isEnablePartData() {
        return this.enablePartData;
    }

    public boolean isEnablePreviewData() {
        return this.enablePreviewData;
    }

    public void setFastEncoder(boolean allowsFastEncoder) {
        this.allowsFastEncoder = allowsFastEncoder;
    }

    public boolean allowsFastEncoder() {
        return this.allowsFastEncoder;
    }

    public int getVersion() {
        return this.fileVersion;
    }
}

