/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSlices;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeCoders;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeEncoder;

public class ChunkCubeData
implements ChunkVariable {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private final int owner;
    private final ChunkPaletteData palette;
    private final LinkedHashMap<Integer, ChunkCubeSection> sections = new LinkedHashMap();
    private final IdentityHashMap<SkinCubes, Collection<ChunkCubeSelector>> pending = new IdentityHashMap();

    public ChunkCubeData(ChunkPaletteData palette) {
        this.owner = ID.incrementAndGet();
        this.palette = palette;
    }

    @Override
    public boolean freeze() {
        if (!this.palette.isResolved()) {
            return false;
        }
        int offset = 0;
        ArrayList<ChunkCubeSection> sortedSections = new ArrayList<ChunkCubeSection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(this::_key));
        for (ChunkCubeSection section : sortedSections) {
            if (!section.isResolved()) {
                section.freeze(offset);
            }
            offset += section.getCubeTotal();
        }
        this.pending.clear();
        return true;
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        ChunkCubeSection.Immutable section;
        int offset = 0;
        while ((section = this.readSectionFromStream(stream)) != null) {
            this.sections.put(this._key(section), section);
            section.freeze(offset);
            offset += section.getCubeTotal();
        }
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        ArrayList<ChunkCubeSection> sortedSections = new ArrayList<ChunkCubeSection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(ChunkCubeSection::getIndex));
        for (ChunkCubeSection section : sortedSections) {
            this.writeSectionToStream(section, stream);
        }
        this.writeSectionToStream(null, stream);
    }

    public SkinCubes readReferenceFromStream(ChunkInputStream stream) throws IOException {
        ArrayList<ChunkCubeSelector> selectors = new ArrayList<ChunkCubeSelector>();
        int count = stream.readVarInt();
        for (int i = 0; i < count; ++i) {
            int index = stream.readInt();
            int size = stream.readInt();
            ChunkCubeSection section = this._sectionAt(index);
            if (section == null) continue;
            int offset = index - section.getIndex();
            selectors.add(new ChunkCubeSelector(section, offset, offset + size));
        }
        return new ChunkCubeSlices(this.owner, selectors, this.palette);
    }

    public void writeReferenceToStream(SkinCubes cubes, ChunkOutputStream streamIn) throws IOException {
        if (streamIn.getContext().allowsFastEncoder() && cubes instanceof ChunkCubeSlices) {
            ChunkCubeSlices slices = (ChunkCubeSlices)cubes;
            Collection selectors = this.pending.computeIfAbsent(cubes, k -> slices.getSelectors());
            this.palette.copyFrom(slices.getPalette());
            streamIn.writeVarInt(selectors.size());
            for (ChunkCubeSelector selector : selectors) {
                ChunkCubeSection section2 = selector.getSection();
                this.sections.put(this._key(section2), section2);
                streamIn.writeVariable(selector);
            }
            return;
        }
        Collection selectors = this.pending.computeIfAbsent(cubes, k -> new ArrayList());
        if (selectors.isEmpty()) {
            LinkedHashMap<ChunkCubeSection, Integer> changes = this._encodeCubeData(cubes, streamIn.getContext());
            changes.forEach((section, startIndex) -> {
                int endIndex = section.getCubeTotal();
                selectors.add(new ChunkCubeSelector((ChunkCubeSection)section, (int)startIndex, endIndex));
            });
        }
        streamIn.writeVarInt(selectors.size());
        for (ChunkCubeSelector selector : selectors) {
            streamIn.writeVariable(selector);
        }
    }

    private ChunkCubeSection.Immutable readSectionFromStream(ChunkInputStream stream) throws IOException {
        int cubeTotal = stream.readVarInt();
        if (cubeTotal == 0) {
            return null;
        }
        ISkinCubeType cubeType = SkinCubeTypes.byId(stream.readVarInt());
        int options = stream.readVarInt();
        ChunkCubeSection.Immutable section = new ChunkCubeSection.Immutable(cubeTotal, options, cubeType, this.palette);
        section.readFromStream(stream);
        return section;
    }

    private void writeSectionToStream(ChunkCubeSection section, IOutputStream stream) throws IOException {
        if (section == null || section.isEmpty()) {
            stream.writeVarInt(0);
            return;
        }
        stream.writeVarInt(section.getCubeTotal());
        stream.writeVarInt(section.getCubeType().getId());
        stream.writeVarInt(section.getCubeOptions());
        section.writeToStream(stream);
    }

    private LinkedHashMap<ChunkCubeSection, Integer> _encodeCubeData(SkinCubes cubes, ChunkContext context) throws IOException {
        LinkedHashMap<ChunkCubeSection, Integer> changes = new LinkedHashMap<ChunkCubeSection, Integer>();
        int size = cubes.getCubeTotal();
        for (int i = 0; i < size; ++i) {
            SkinCube cube = cubes.getCube(i);
            ISkinCubeType cubeType = cube.getType();
            ChunkCubeEncoder cubeEncoder = ChunkCubeCoders.createEncoder(cubeType);
            ChunkCubeSection.Mutable section = this._mutableSectionAt(cubeType, cubeEncoder.begin(cube), context);
            changes.putIfAbsent(section, section.getCubeTotal());
            section.write(cubeEncoder, this.palette);
        }
        return changes;
    }

    private Integer _key(ChunkCubeSection section) {
        return this._key(section.getCubeType(), section.getCubeOptions());
    }

    private Integer _key(ISkinCubeType cubeType, int options) {
        return cubeType.getId() << 24 | options;
    }

    private ChunkCubeSection _sectionAt(int index) {
        for (ChunkCubeSection section : this.sections.values()) {
            int startIndex = section.getIndex();
            int endIndex = section.getCubeTotal() + startIndex;
            if (startIndex > index || index >= endIndex) continue;
            return section;
        }
        return null;
    }

    private ChunkCubeSection.Mutable _mutableSectionAt(ISkinCubeType cubeType, int options, ChunkContext context) {
        Integer key = this._key(cubeType, options);
        ChunkCubeSection section = this.sections.computeIfAbsent(key, it -> new ChunkCubeSection.Mutable(options, cubeType, context));
        return (ChunkCubeSection.Mutable)section;
    }
}

