/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeCoders;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SliceRandomlyAccessor;

public class ChunkCubeSlices
extends SkinCubes {
    private final int total;
    private final ThreadLocal<SliceRandomlyAccessor<SkinCube>> accessor;
    private final List<ChunkCubeSelector> selectors;
    private final ChunkPaletteData palette;

    public ChunkCubeSlices(int owner, List<ChunkCubeSelector> selectors, ChunkPaletteData palette) {
        this.owner = owner;
        this.palette = palette;
        this.selectors = selectors;
        this.accessor = ThreadLocal.withInitial(() -> ChunkCubeSlices.build(selectors));
        this.total = ObjectUtils.sum(selectors, ChunkCubeSelector::getCount);
    }

    @Override
    public int getCubeTotal() {
        return this.total;
    }

    @Override
    public SkinCube getCube(int index) {
        return this.accessor.get().get(index);
    }

    @Override
    public Collection<ISkinCubeType> getCubeTypes() {
        return ObjectUtils.map(this.selectors, it -> it.getSection().getCubeType());
    }

    public ChunkPaletteData getPalette() {
        return this.palette;
    }

    public Collection<ChunkCubeSelector> getSelectors() {
        return this.selectors;
    }

    private static SliceRandomlyAccessor<SkinCube> build(List<ChunkCubeSelector> selectors) {
        ArrayList providers = new ArrayList();
        int startIndex = 0;
        int endIndex = 0;
        for (ChunkCubeSelector selector : selectors) {
            providers.add(ChunkCubeCoders.createDecoder(startIndex, endIndex += selector.getCount(), selector, (ChunkCubeSection.Immutable)selector.getSection()));
            startIndex = endIndex;
        }
        return new SliceRandomlyAccessor(providers);
    }
}

