/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.texture.SkinPaintData;

public class ChunkPaintData {
    private final ChunkPaletteData palette;

    public ChunkPaintData(ChunkPaletteData palette) {
        this.palette = palette;
    }

    public SkinPaintData readFromStream(ChunkInputStream stream) throws IOException {
        int width;
        int totalHeight;
        int totalWidth;
        int flags = stream.readVarInt();
        SkinPaintData paintData = this._paintData(flags, totalWidth = stream.readVarInt(), totalHeight = stream.readVarInt());
        if (paintData == null) {
            return null;
        }
        while ((width = stream.readVarInt()) != 0) {
            int height = stream.readVarInt();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    paintData.setColor(x, y, this.palette.readColor(stream));
                }
            }
        }
        return paintData;
    }

    public void writeToStream(SkinPaintData paintData, ChunkOutputStream stream) throws IOException {
        int flags = this._flags(paintData);
        stream.writeVarInt(flags);
        stream.writeVarInt(paintData.getWidth());
        stream.writeVarInt(paintData.getHeight());
        int width = paintData.getWidth();
        int height = paintData.getHeight();
        stream.writeVarInt(width);
        stream.writeVarInt(height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                stream.writeVariable(this.palette.writeColor(paintData.getColor(x, y)));
            }
        }
        stream.writeVarInt(0);
        stream.writeVarInt(0);
    }

    private int _flags(SkinPaintData paintData) {
        return 0;
    }

    private SkinPaintData _paintData(int flags, int width, int height) {
        if (width == 64 && height == 32) {
            return SkinPaintData.v1();
        }
        if (width == 64 && height == 64) {
            return SkinPaintData.v2();
        }
        return null;
    }
}

