/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkColorSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.texture.TextureOptions;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SliceRandomlyAccessor;
import moe.plushie.armourers_workshop.utils.math.Vector2f;

public class ChunkPaletteData
implements ChunkVariable {
    private IPaintColor[] paintColors;
    private final LinkedHashMap<Integer, ChunkColorSection> sections = new LinkedHashMap();
    private SliceRandomlyAccessor<IPaintColor> paintColorAccessor;
    private int freezeCount = 0;
    private int colorUsedIndex = 1;
    private int textureUsedIndex = 4;
    private int flags = 0;
    private int reserved = 0;
    private boolean resolved = false;

    public void copyFrom(ChunkPaletteData palette) {
        this.sections.clear();
        this.sections.putAll(palette.sections);
        this.flags = palette.flags;
        this.reserved = palette.reserved;
        this.colorUsedIndex = palette.colorUsedIndex;
        this.textureUsedIndex = palette.textureUsedIndex;
    }

    public ChunkColorSection.ColorRef writeColor(int rawValue) {
        return this._mutableSectionAt(SkinPaintTypes.NORMAL, 3).putColor(rawValue);
    }

    public ChunkColorSection.ColorRef writeColor(IPaintColor color) {
        int rawValue = color.getRawValue();
        return this._mutableSectionAt(color.getPaintType(), 3).putColor(rawValue);
    }

    public IPaintColor readColor(int index) {
        if (this.paintColors == null || this.paintColorAccessor == null) {
            return PaintColor.WHITE;
        }
        IPaintColor paintColor = this.paintColors[index];
        if (paintColor != null) {
            return paintColor;
        }
        this.paintColors[index] = paintColor = this.paintColorAccessor.get(index);
        return paintColor;
    }

    public IPaintColor readColor(ChunkInputStream stream) throws IOException {
        return this.readColor(ChunkColorSection.ColorRef.readFromStream(this.colorUsedIndex, stream));
    }

    public IPaintColor readColorFromStream(byte[] bytes, int offset) {
        return this.readColor(ChunkColorSection.ColorRef.readFromStream(this.colorUsedIndex, offset, bytes));
    }

    public ChunkColorSection.TextureRef writeTexture(Vector2f uv, ITextureProvider provider) {
        return this._mutableSectionAt(SkinPaintTypes.TEXTURE, 0).putTexture(uv, provider);
    }

    public ChunkColorSection.TextureRef readTexture(Vector2f uv) {
        return this._sectionAt(SkinPaintTypes.TEXTURE, 0).getTexture(uv);
    }

    public ChunkColorSection.OptionsRef writeTextureOptions(TextureOptions options, ITextureProvider provider) {
        return this._mutableSectionAt(SkinPaintTypes.TEXTURE, 0).putTextureOptions(options);
    }

    @Override
    public boolean freeze() {
        ++this.freezeCount;
        if (this.freezeCount <= 1) {
            return false;
        }
        if (this.resolved) {
            return true;
        }
        int offset = 0;
        ArrayList<ChunkColorSection> sortedSections = new ArrayList<ChunkColorSection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(this::_key));
        for (ChunkColorSection section : sortedSections) {
            if (!section.isResolved()) {
                section.freeze(offset);
            }
            offset += section.getSize();
        }
        this.colorUsedIndex = this._used(offset);
        this.textureUsedIndex = 4;
        this.flags = this.colorUsedIndex & 0xF | (this.textureUsedIndex & 0xF) << 4;
        for (ChunkColorSection section : sortedSections) {
            section.freezeIndex(this.colorUsedIndex, this.textureUsedIndex);
        }
        this.resolved = true;
        return true;
    }

    public void readFromStream(IInputStream stream) throws IOException {
        ChunkColorSection section;
        int offset = 0;
        int colorOffset = 0;
        this.flags = stream.readVarInt();
        this.reserved = stream.readVarInt();
        while ((section = this.readSectionFromStream(stream)) != null) {
            this.sections.put(this._key(section), section);
            section.freeze(offset);
            offset += section.getSize();
            if (section.isTexture()) continue;
            colorOffset += section.getSize();
        }
        this.paintColors = new IPaintColor[colorOffset];
        this.paintColorAccessor = new SliceRandomlyAccessor<IPaintColor>(ObjectUtils.map(this.sections.values(), ColorAccessor::new));
        this.colorUsedIndex = this.flags & 0xF;
        this.textureUsedIndex = this.flags >> 4 & 0xF;
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        ArrayList<ChunkColorSection> sortedSections = new ArrayList<ChunkColorSection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(ChunkColorSection::getStartIndex));
        stream.writeVarInt(this.flags);
        stream.writeVarInt(this.reserved);
        for (ChunkColorSection section : sortedSections) {
            this.writeSectionToStream(section, stream);
        }
        this.writeSectionToStream(null, stream);
    }

    private ChunkColorSection readSectionFromStream(IInputStream stream) throws IOException {
        int total = stream.readVarInt();
        if (total == 0) {
            return null;
        }
        SkinPaintType paintType = SkinPaintTypes.byId(stream.readByte());
        byte usedBytes = stream.readByte();
        ChunkColorSection.Immutable section = new ChunkColorSection.Immutable(total, usedBytes, paintType);
        section.readFromStream(stream);
        return section;
    }

    private void writeSectionToStream(ChunkColorSection section, IOutputStream stream) throws IOException {
        if (section == null) {
            stream.writeVarInt(0);
            return;
        }
        stream.writeVarInt(section.getSize());
        stream.writeByte(section.getPaintType().getId());
        stream.writeByte(section.getUsedBytes());
        section.writeToStream(stream);
    }

    public int getColorIndexBytes() {
        return this.colorUsedIndex;
    }

    public int getTextureIndexBytes() {
        return this.textureUsedIndex;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    private Integer _key(ChunkColorSection section) {
        return section.getPaintType().getId() << 24 | section.getUsedBytes();
    }

    private ChunkColorSection _sectionAt(ISkinPaintType paintType, int usedBytes) {
        return this.sections.get(paintType.getId() << 24 | usedBytes);
    }

    private ChunkColorSection.Mutable _mutableSectionAt(ISkinPaintType paintType, int usedBytes) {
        return (ChunkColorSection.Mutable)this.sections.computeIfAbsent(paintType.getId() << 24 | usedBytes, k -> new ChunkColorSection.Mutable(usedBytes, paintType));
    }

    private int _used(int size) {
        for (int i = 1; i < 4; ++i) {
            if (size >>> i * 8 != 0) continue;
            return i;
        }
        return 4;
    }

    public static class ColorAccessor
    implements SliceRandomlyAccessor.Provider<IPaintColor> {
        private final ChunkColorSection section;

        public ColorAccessor(ChunkColorSection section) {
            this.section = section;
        }

        @Override
        public IPaintColor get(int index) {
            return this.section.getColor(index);
        }

        @Override
        public int getStartIndex() {
            return this.section.getStartIndex();
        }

        @Override
        public int getEndIndex() {
            return this.section.getEndIndex();
        }
    }
}

