/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTransform;
import moe.plushie.armourers_workshop.core.texture.SkinPreviewData;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkPreviewData {
    private final ChunkCubeData chunkCubeData;

    public ChunkPreviewData(ChunkCubeData chunkCubeData) {
        this.chunkCubeData = chunkCubeData;
    }

    public SkinPreviewData readFromStream(ChunkInputStream stream) throws IOException {
        int count;
        ChunkTransform chunkTransform = new ChunkTransform();
        ArrayList<Pair<ISkinTransform, SkinCubes>> sections = new ArrayList<Pair<ISkinTransform, SkinCubes>>();
        while ((count = stream.readVarInt()) != 0) {
            int id = stream.readVarInt();
            chunkTransform.readFromStream(stream);
            for (int i = 0; i < count; ++i) {
                SkinCubes cubes = this.chunkCubeData.readReferenceFromStream(stream);
                sections.add((Pair<ISkinTransform, SkinCubes>)Pair.of((Object)chunkTransform.build(), (Object)cubes));
            }
        }
        return new SkinPreviewData(sections);
    }

    public void writeToStream(SkinPreviewData previewData, ChunkOutputStream stream) throws IOException {
        LinkedHashMap sections = new LinkedHashMap();
        previewData.forEach((transform, cubeData) -> {
            ChunkTransform chunkTransform = ChunkTransform.flat(transform);
            sections.computeIfAbsent(chunkTransform, k -> new ArrayList()).add(cubeData);
        });
        for (Map.Entry section : sections.entrySet()) {
            stream.writeVarInt(((ArrayList)section.getValue()).size());
            stream.writeVarInt(0);
            ((ChunkTransform)section.getKey()).writeToStream(stream);
            for (SkinCubes cubes : (ArrayList)section.getValue()) {
                this.chunkCubeData.writeReferenceToStream(cubes, stream);
            }
        }
        stream.writeVarInt(0);
    }
}

