/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.Chunk;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import org.jetbrains.annotations.Nullable;

public class ChunkReader {
    protected final ChunkInputStream stream;
    protected final Predicate<String> chunkFilter;
    protected final ArrayList<Entry> entries = new ArrayList();

    public ChunkReader(ChunkInputStream stream, Predicate<String> chunkFilter) {
        this.stream = stream;
        this.chunkFilter = chunkFilter;
    }

    protected void prepare() throws IOException {
        int length;
        while ((length = this.stream.readInt()) != 0) {
            EntryBuilder builder = new EntryBuilder(length);
            this.readHeader(builder);
            if (this.chunkFilter != null && !this.chunkFilter.test(builder.name)) {
                this.stream.getInputStream().skipBytes(builder.getBodySize());
                this.readFooter(builder);
                continue;
            }
            this.readContent(builder);
            this.readFooter(builder);
            this.entries.add(builder.build(this.stream.getContext()));
        }
    }

    @Nullable
    public <T> T read(ChunkSerializer<T, Void> serializer) throws IOException {
        return this.read(serializer, null);
    }

    @Nullable
    public <T, C> T read(ChunkSerializer<T, C> serializer, C context) throws IOException {
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!serializer.canRead(entry.name)) continue;
            iterator.remove();
            return entry.read(serializer, context);
        }
        return serializer.getDefaultValue();
    }

    public <T> Collection<T> readAll(ChunkSerializer<T, Void> serializer) throws IOException {
        return this.readAll(serializer, null);
    }

    public <T, C> Collection<T> readAll(ChunkSerializer<T, C> serializer, C context) throws IOException {
        ArrayList<T> results = new ArrayList<T>();
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!serializer.canRead(entry.name)) continue;
            iterator.remove();
            T result = entry.read(serializer, context);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public Object readBlobs() throws IOException {
        if (!this.entries.isEmpty()) {
            return new ArrayList<Entry>(this.entries);
        }
        return null;
    }

    protected void readHeader(EntryBuilder builder) throws IOException {
        builder.name = this.stream.readString(4);
        builder.flags = ChunkFlags.readFromStream(this.stream);
    }

    protected void readContent(EntryBuilder builder) throws IOException {
        builder.buffer = this.stream.readBytes(builder.getBodySize());
    }

    protected void readFooter(EntryBuilder builder) throws IOException {
    }

    protected static class EntryBuilder {
        String name;
        ChunkFlags flags;
        int length;
        int header = 10;
        ByteBuf buffer;
        Object extra;

        EntryBuilder(int length) {
            this.length = length;
        }

        public Entry build(ChunkContext context) {
            return new Entry(this.name, this.flags, this.length, this.buffer, this.extra, context);
        }

        public int getBodySize() {
            return this.length - this.header;
        }
    }

    protected static class Entry
    implements Chunk {
        protected final String name;
        protected final ChunkFlags flags;
        protected final int length;
        protected final ByteBuf buffer;
        protected ChunkInputStream inputStream;
        protected final ChunkContext context;
        protected final Object extra;

        public Entry(String name, ChunkFlags flags, int length, ByteBuf buffer, Object extra, ChunkContext context) {
            this.length = length;
            this.name = name;
            this.flags = flags;
            this.buffer = buffer;
            this.extra = extra;
            this.context = context;
        }

        public <T, C> T read(ChunkSerializer<T, C> serializer, C obj) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new ChunkInputStream(new DataInputStream(this.context.createInputStream(this.buffer, this.flags)), this.context, null);
            }
            return serializer.read(this.inputStream, this.name, obj);
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeBytes(this.buffer);
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ChunkFlags getFlags() {
            return this.flags;
        }
    }
}

