/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.v1;

import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeDecoder;
import moe.plushie.armourers_workshop.utils.DirectionUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.core.Direction;

public class ChunkCubeDecoderV1
extends ChunkCubeDecoder {
    private boolean isParsed = false;

    public ChunkCubeDecoderV1(int startIndex, int endIndex, ChunkCubeSelector selector, ChunkCubeSection.Immutable section) {
        super(startIndex, endIndex, selector, section);
    }

    public static int getStride(int options, ChunkPaletteData palette) {
        int faceCount = options & 0xF;
        return ChunkCubeDecoderV1.calcStride(palette.getColorIndexBytes(), faceCount);
    }

    public static int calcStride(int usedBytes, int size) {
        return 3 + (1 + usedBytes) * size;
    }

    @Override
    public Vector3i getPosition() {
        this.pos.setX(this.getByte(0));
        this.pos.setY(this.getByte(1));
        this.pos.setZ(this.getByte(2));
        return this.pos;
    }

    @Override
    public IPaintColor getPaintColor(Direction dir) {
        this.parseColorsIfNeeded();
        return super.getPaintColor(dir);
    }

    protected void parseColorsIfNeeded() {
        if (this.isParsed) {
            return;
        }
        int usedBytes = this.palette.getColorIndexBytes();
        for (int i = 0; i < this.faceCount; ++i) {
            byte face = this.getByte(ChunkCubeDecoderV1.calcStride(usedBytes, i));
            IPaintColor color = this.palette.readColorFromStream(this.bytes, this.readerIndex + ChunkCubeDecoderV1.calcStride(usedBytes, i) + 1);
            for (Direction dir : DirectionUtils.valuesFromSet(face)) {
                super.setPaintColor(dir, color);
            }
        }
        this.isParsed = true;
    }

    @Override
    protected void reset() {
        this.isParsed = false;
    }
}

