/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer;

import java.io.IOException;
import java.util.Collection;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.api.core.IResource;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPackModelReader;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import org.jetbrains.annotations.Nullable;

public abstract class SkinPackReader {
    protected final String name;
    protected final Collection<IResource> resources;
    protected Vector3f offset = Vector3f.ZERO;

    protected SkinPackReader(String name, Collection<IResource> resources) {
        this.name = name;
        this.resources = resources;
    }

    public abstract void loadEntityModel(IOConsumer<SkinPackModelReader> var1) throws IOException;

    @Nullable
    public IResource findResource(String regex) {
        Pattern pattern = Pattern.compile(regex, 2);
        for (IResource resource : this.resources) {
            if (!pattern.matcher(resource.getName()).find()) continue;
            return resource;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public IResource getResource(String name) {
        for (IResource resource : this.resources) {
            if (!resource.getName().equalsIgnoreCase(name)) continue;
            return resource;
        }
        return null;
    }

    public Collection<IResource> getResources() {
        return this.resources;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public Vector3f getOffset() {
        return this.offset;
    }
}

