/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.bedrock;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinArmorType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationFunction;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationValue;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV0;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV2;
import moe.plushie.armourers_workshop.core.skin.molang.MolangVirtualMachine;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelBone;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchAnimation;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchAnimator;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchKeyFrame;
import moe.plushie.armourers_workshop.core.texture.TextureBox;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Size3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import org.apache.commons.lang3.tuple.Pair;

public class BedrockModelExporter {
    protected SkinSettings settings = new SkinSettings();
    protected SkinProperties properties = new SkinProperties();
    protected SkinItemTransforms itemTransforms;
    protected Node rootNode = new Node("", null, null);
    protected HashMap<String, Node> namedNodes = new HashMap();
    protected ArrayList<Pair<String, Node>> allNodes = new ArrayList();
    protected ArrayList<BlockBenchAnimation> allAnimations = new ArrayList();
    protected boolean keepItemTransforms = false;

    public void add(BedrockModelBone bone, BedrockModelTexture texture) {
        Node node = new Node(bone.getId(), bone, texture);
        this.allNodes.add((Pair<String, Node>)Pair.of((Object)bone.getParent(), (Object)node));
        this.namedNodes.put(bone.getId(), node);
    }

    public void add(BlockBenchAnimation animation) {
        this.allAnimations.add(animation);
    }

    public void add(String name, ITransformf transform) {
        if (this.itemTransforms == null) {
            this.itemTransforms = new SkinItemTransforms();
        }
        if (!transform.isIdentity()) {
            this.itemTransforms.put(name, transform);
        }
    }

    public <T> void add(ISkinProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public Skin export(ISkinType skinType) {
        this.allNodes.forEach((Consumer<Pair<String, Node>>)((Consumer<Pair>)it -> {
            String parentId = (String)it.getKey();
            if (parentId == null || parentId.isEmpty()) {
                this.rootNode.add((Node)it.getValue());
                return;
            }
            Node parent = this.namedNodes.get(parentId);
            if (parent == null) {
                parent = new Node(parentId, null, null);
                this.rootNode.add(parent);
                this.namedNodes.put(parentId, parent);
            }
            parent.add((Node)it.getValue());
        }));
        Mapper mapper = Mapper.of(skinType);
        ArrayList<SkinPart> rootParts = new ArrayList<SkinPart>();
        for (Node child : this.rootNode.children) {
            this.exportSkinPart(child, null, rootParts, mapper);
        }
        List<SkinAnimation> animations = this.exportSkinAnimations();
        Skin.Builder builder = this.createSkin(skinType);
        if (skinType == SkinTypes.ADVANCED || skinType == SkinTypes.OUTFIT || skinType == SkinTypes.ITEM_BOW || skinType == SkinTypes.ITEM_FISHING || skinType instanceof ISkinArmorType) {
            builder.parts(rootParts);
        } else if (skinType.getParts().size() == 1) {
            SkinPart.Builder builder1 = new SkinPart.Builder(skinType.getParts().get(0));
            builder1.cubes(new SkinCubesV0(0));
            SkinPart rootPart = builder1.build();
            rootParts.forEach(rootPart::addPart);
            builder.parts(Collections.singleton(rootPart));
        } else {
            builder.parts(rootParts);
        }
        builder.settings(this.settings);
        builder.properties(this.properties);
        if (this.isKeepItemTransforms()) {
            this.settings.setItemTransforms(this.itemTransforms);
        }
        builder.animations(animations);
        builder.version(20);
        return builder.build();
    }

    protected Skin.Builder createSkin(ISkinType skinType) {
        return new Skin.Builder(skinType);
    }

    protected void exportSkinPart(Node node, SkinPart parentPart, Collection<SkinPart> rootParts, Mapper mapper) {
        Vector3f origin = Vector3f.ZERO;
        Mapper.Entry entry = mapper.get(node.bone.getName());
        if (entry.isRootPart()) {
            parentPart = null;
            origin = node.bone.getPivot();
        }
        SkinPart part = this.exportSkinPart(node, origin, entry);
        if (parentPart != null) {
            parentPart.addPart(part);
        } else {
            rootParts.add(part);
        }
        for (Node child : node.children) {
            this.exportSkinPart(child, part, rootParts, mapper);
        }
    }

    protected SkinPart exportSkinPart(Node node, Vector3f origin, Mapper.Entry entry) {
        BedrockModelBone bone = node.bone;
        Vector3f pivot = Vector3f.ZERO;
        Vector3f translate = origin.subtracting(entry.getOffset()).scaling(-1.0f);
        Vector3f rotation = Vector3f.ZERO;
        if (bone != null && !entry.isRootPart()) {
            pivot = bone.getPivot();
            rotation = bone.getRotation();
        }
        SkinCubesV2 cubes = new SkinCubesV2();
        SkinPart.Builder builder = new SkinPart.Builder(entry.getType());
        builder.cubes(cubes);
        builder.transform(SkinTransform.create(Vector3f.ZERO, rotation, Vector3f.ONE, pivot, translate));
        if (bone != null) {
            builder.name(bone.getName());
            for (BedrockModelCube cube : bone.getCubes()) {
                SkinCubesV2.Box box = this.exportSkinCube(cube, node.texture);
                cubes.addBox(box);
            }
        }
        return builder.build();
    }

    protected SkinCubesV2.Box exportSkinCube(BedrockModelCube cube, BedrockModelTexture texture) {
        Vector3f pivot = cube.getPivot();
        Vector3f translate = Vector3f.ZERO;
        Vector3f rotation = cube.getRotation();
        Vector3f origin = cube.getOrigin();
        Size3f size = cube.getSize();
        float x = origin.getX();
        float y = origin.getY();
        float z = origin.getZ();
        float w = size.getWidth();
        float h = size.getHeight();
        float d = size.getDepth();
        float inflate = cube.getInflate();
        TextureBox skyBox = texture.read(cube);
        if (inflate != 0.0f) {
            skyBox = skyBox.separated();
        }
        Rectangle3f rect = new Rectangle3f(x, y, z, w, h, d).inflate(inflate);
        SkinTransform transform = SkinTransform.create(Vector3f.ZERO, rotation, Vector3f.ONE, pivot, translate);
        return new SkinCubesV2.Box(rect, transform, skyBox);
    }

    protected List<SkinAnimation> exportSkinAnimations() {
        ArrayList<SkinAnimation> results = new ArrayList<SkinAnimation>();
        this.allAnimations.forEach(animation -> {
            String name = animation.getName();
            float duration = animation.getDuration();
            SkinAnimationLoop loop = switch (animation.getLoop()) {
                case "once" -> SkinAnimationLoop.NONE;
                case "hold" -> SkinAnimationLoop.LAST_FRAME;
                case "loop" -> SkinAnimationLoop.LOOP;
                default -> SkinAnimationLoop.LOOP;
            };
            Map<String, List<SkinAnimationValue>> values = this.exportSkinAnimationValues(animation.getAnimators());
            if (values.isEmpty()) {
                return;
            }
            results.add(new SkinAnimation(name, duration, loop, values));
        });
        return results;
    }

    protected Map<String, List<SkinAnimationValue>> exportSkinAnimationValues(List<BlockBenchAnimator> animators) {
        LinkedHashMap<String, List<SkinAnimationValue>> results = new LinkedHashMap<String, List<SkinAnimationValue>>();
        block8: for (BlockBenchAnimator animator : animators) {
            switch (animator.getType()) {
                case "bone": {
                    List values = results.computeIfAbsent(animator.getName(), k -> new ArrayList());
                    for (BlockBenchKeyFrame keyframe : animator.getKeyframes()) {
                        float time = keyframe.getTime();
                        String channel = keyframe.getName();
                        SkinAnimationFunction function = this.exportSkinAnimationFunction(keyframe);
                        ArrayList<Object> points = new ArrayList<Object>();
                        for (Object point : keyframe.getPoints()) {
                            points.add(this.exportSkinAnimationValue(point));
                        }
                        if (channel.equals("position")) {
                            this.fixAnimationPosition(points);
                        }
                        values.add(new SkinAnimationValue(time, channel, function, points));
                    }
                    continue block8;
                }
                case "effect": {
                    ModLog.warn("not supported yet of effect", new Object[0]);
                    break;
                }
                default: {
                    ModLog.warn("a unknown type of '{}'", animator.getType());
                }
            }
        }
        return results;
    }

    private Object exportSkinAnimationValue(Object value) {
        if (value instanceof String) {
            String script = (String)value;
            try {
                if (script.isEmpty()) {
                    return Float.valueOf(0.0f);
                }
                Expression expr = MolangVirtualMachine.get().eval(script);
                if (expr.isMutable()) {
                    return script;
                }
                return Float.valueOf(expr.getAsFloat());
            }
            catch (Exception exception) {
                throw new RuntimeException("can't parse \"" + script + "\" in model!", exception);
            }
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        return Float.valueOf(0.0f);
    }

    private SkinAnimationFunction exportSkinAnimationFunction(BlockBenchKeyFrame keyframe) {
        return switch (keyframe.getInterpolation()) {
            case "bezier" -> SkinAnimationFunction.linear();
            case "linear" -> SkinAnimationFunction.linear();
            case "step" -> SkinAnimationFunction.step();
            case "smooth" -> SkinAnimationFunction.smooth();
            default -> SkinAnimationFunction.linear();
        };
    }

    private void fixAnimationPosition(List<Object> values) {
        int count = values.size();
        for (int i = 0; i < count; ++i) {
            if (i % 3 != 1) continue;
            Object value = values.get(i);
            if (value instanceof String) {
                String script = (String)value;
                value = "-(" + script + ")";
            } else if (value instanceof Number) {
                Number number = (Number)value;
                value = Float.valueOf(-number.floatValue());
            }
            Object object = values.set(i, value);
        }
    }

    public boolean isKeepItemTransforms() {
        return this.keepItemTransforms;
    }

    public void setKeepItemTransforms(boolean keepItemTransforms) {
        this.keepItemTransforms = keepItemTransforms;
    }

    public static class Node {
        public final String id;
        public final BedrockModelBone bone;
        public final BedrockModelTexture texture;
        public final ArrayList<Node> children = new ArrayList();

        public Node(String id, BedrockModelBone bone, BedrockModelTexture texture) {
            this.id = id;
            this.bone = bone;
            this.texture = texture;
        }

        public void add(Node node) {
            this.children.add(node);
        }
    }

    public static class Mapper {
        private final Function<String, Entry> provider;
        private static final ImmutableMap<String, ISkinPartType> BOW_PARTS = new ImmutableMap.Builder().put((Object)"Arrow", (Object)SkinPartTypes.ITEM_ARROW).put((Object)"Frame0", (Object)SkinPartTypes.ITEM_BOW0).put((Object)"Frame1", (Object)SkinPartTypes.ITEM_BOW1).put((Object)"Frame2", (Object)SkinPartTypes.ITEM_BOW2).put((Object)"Frame3", (Object)SkinPartTypes.ITEM_BOW3).build();
        private static final ImmutableMap<String, ISkinPartType> FINISHING_PARTS = new ImmutableMap.Builder().put((Object)"Hook", (Object)SkinPartTypes.ITEM_FISHING_HOOK).put((Object)"Frame0", (Object)SkinPartTypes.ITEM_FISHING_ROD).put((Object)"Frame1", (Object)SkinPartTypes.ITEM_FISHING_ROD1).build();

        public Mapper(Function<String, Entry> provider) {
            this.provider = provider;
        }

        public static Mapper of(ISkinType skinType) {
            if (skinType == SkinTypes.ITEM_BOW) {
                return Mapper.of(BOW_PARTS);
            }
            if (skinType == SkinTypes.ITEM_FISHING) {
                return Mapper.of(FINISHING_PARTS);
            }
            return Mapper.of(Armatures.byType(skinType));
        }

        public static Mapper of(Armature armature) {
            return new Mapper(name -> {
                ISkinPartType partType;
                IJoint joint = armature.getJoint((String)name);
                if (joint != null && (partType = armature.getPartType(joint)) != null) {
                    return new Entry(joint, partType);
                }
                return null;
            });
        }

        public static Mapper of(Map<String, ISkinPartType> map) {
            return new Mapper(name -> {
                ISkinPartType partType = (ISkinPartType)map.get(name);
                if (partType != null) {
                    return new Entry(null, partType);
                }
                return null;
            });
        }

        public Entry get(String name) {
            Entry entry = this.provider.apply(name);
            if (entry != null) {
                return entry;
            }
            return Entry.NONE;
        }

        public static class Entry {
            public static final Entry NONE = new Entry(null, SkinPartTypes.ADVANCED);
            private final ISkinPartType type;

            public Entry(IJoint joint, ISkinPartType type) {
                this.type = type;
            }

            public boolean isRootPart() {
                return this.type != SkinPartTypes.ADVANCED;
            }

            public Vector3f getOffset() {
                if (this.type == SkinPartTypes.BIPPED_CHEST || this.type == SkinPartTypes.BIPPED_TORSO) {
                    return new Vector3f(0.0f, 6.0f, 0.0f);
                }
                return Vector3f.ZERO;
            }

            public ISkinPartType getType() {
                return this.type;
            }
        }
    }
}

