/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.blockbench;

import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.api.common.ITextureProperties;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelUV;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchModelUV;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchTexture;
import moe.plushie.armourers_workshop.core.texture.TextureAnimation;
import moe.plushie.armourers_workshop.core.texture.TextureData;
import moe.plushie.armourers_workshop.core.texture.TextureProperties;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.Size2f;
import net.minecraft.core.Direction;

public class BlockBenchModelTexture
extends BedrockModelTexture {
    private static final String PATTERN = "^(.+)_([nes]+)(\\.\\w+)?$";
    private final Size2f resolution;
    private final List<BlockBenchTexture> inputs;
    private final HashMap<Integer, TextureData> allTexture = new HashMap();
    private final HashMap<String, TextureData> loadedTextures = new HashMap();
    protected TextureData defaultTextureData;

    public BlockBenchModelTexture(Size2f resolution, List<BlockBenchTexture> textureInputs) {
        this.resolution = resolution;
        this.inputs = textureInputs;
    }

    public void load(HashSet<Integer> usedTextureIds) throws IOException {
        if (this.defaultTextureData != null) {
            return;
        }
        for (Integer textureId : usedTextureIds) {
            if (textureId.compareTo(0) < 0 || textureId.compareTo(this.inputs.size()) >= 0) continue;
            BlockBenchTexture texture = this.inputs.get(textureId);
            TextureData data = this.loadTextureData(texture);
            this.allTexture.put(textureId, data);
            if (this.defaultTextureData != null) continue;
            this.defaultTextureData = data;
        }
        this.textureData = this.defaultTextureData;
        if (this.textureData == null) {
            throw new IOException("error.bb.loadModel.noTexture");
        }
    }

    @Override
    protected TextureData getTextureData(BedrockModelCube cube) {
        BedrockModelUV bedrockModelUV = cube.getUV();
        if (bedrockModelUV instanceof BlockBenchModelUV) {
            BlockBenchModelUV uv = (BlockBenchModelUV)bedrockModelUV;
            return this.allTexture.get(uv.getDefaultTextureId());
        }
        return null;
    }

    @Override
    protected TextureData getTextureData(BedrockModelCube cube, Direction dir) {
        BedrockModelUV bedrockModelUV = cube.getUV();
        if (bedrockModelUV instanceof BlockBenchModelUV) {
            BlockBenchModelUV uv = (BlockBenchModelUV)bedrockModelUV;
            return this.allTexture.get(uv.getTextureId(dir));
        }
        return null;
    }

    private TextureData loadTextureData(BlockBenchTexture texture) throws IOException {
        TextureData data = this.resolveTextureData(texture);
        ArrayList<ITextureProvider> variants = new ArrayList<ITextureProvider>();
        String parentName = texture.getName().replaceAll(PATTERN, "$1$3");
        Collection<String> parentAttributes = this.getTextureAttributes(texture.getName());
        for (BlockBenchTexture childTexture : this.inputs) {
            Collection<String> childAttributes;
            String childName = childTexture.getName().replaceAll(PATTERN, "$1$3");
            if (!childName.equals(parentName) || childTexture == texture || !(childAttributes = this.getTextureAttributes(childTexture.getName())).containsAll(parentAttributes)) continue;
            TextureData childData = this.resolveTextureData(childTexture);
            if (data.getProperties().isEmissive()) {
                childData.getProperties().setEmissive(true);
            }
            variants.add(childData);
        }
        data.setVariants(variants);
        Resolution.apply(data);
        return data;
    }

    private TextureData resolveTextureData(BlockBenchTexture texture) throws IOException {
        TextureData textureData = this.loadedTextures.get(texture.getUUID());
        if (textureData != null) {
            return textureData;
        }
        String str = texture.getSource();
        String[] parts = str.split(";base64,");
        if (parts.length != 2) {
            throw new IOException("error.bb.loadModel.textureNotSupported");
        }
        byte[] imageBytes = Base64.getDecoder().decode(parts[1]);
        int imageFrame = this.resolveTextureFrame(texture, imageBytes);
        Size2f size = this.resolveTextureSize(texture, imageFrame);
        TextureAnimation animation = this.resolveTextureAnimation(texture, imageFrame);
        TextureProperties properties = this.resolveTextureProperties(texture);
        textureData = new TextureData(texture.getName(), size.getWidth(), size.getHeight(), animation, properties);
        textureData.load(Unpooled.wrappedBuffer((byte[])imageBytes));
        this.loadedTextures.put(texture.getUUID(), textureData);
        return textureData;
    }

    private int resolveTextureFrame(BlockBenchTexture texture, byte[] imageBytes) throws IOException {
        Size2f imageSize = texture.getImageSize();
        if (imageSize == null) {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            imageSize = new Size2f(image.getWidth(), image.getHeight());
        }
        int width = MathUtils.floor(imageSize.getWidth());
        int height = MathUtils.floor(imageSize.getHeight());
        int frame = height / width;
        if (frame * width == height) {
            return frame;
        }
        return 0;
    }

    private Size2f resolveTextureSize(BlockBenchTexture texture, int frameCount) {
        float width = this.resolution.getWidth();
        float height = this.resolution.getHeight();
        if (texture.getTextureSize() != null) {
            width = texture.getTextureSize().getWidth();
            height = texture.getTextureSize().getHeight();
        }
        if (frameCount > 1) {
            height = width * (float)frameCount;
        }
        return new Size2f(width, height);
    }

    private TextureAnimation resolveTextureAnimation(BlockBenchTexture texture, int frameCount) {
        if (frameCount > 1) {
            int time = texture.getFrameTime() * 50;
            boolean interpolate = texture.getFrameInterpolate();
            TextureAnimation.Mode mode = texture.getFrameMode();
            return new TextureAnimation(time, frameCount, mode, interpolate);
        }
        return TextureAnimation.EMPTY;
    }

    private TextureProperties resolveTextureProperties(BlockBenchTexture texture) {
        TextureProperties properties = texture.getProperties();
        Iterator<String> iterator = this.getTextureAttributes(texture.getName()).iterator();
        while (iterator.hasNext()) {
            String attrib;
            switch (attrib = iterator.next()) {
                case "n": {
                    properties.setNormal(true);
                    break;
                }
                case "e": {
                    properties.setEmissive(true);
                    break;
                }
                case "s": {
                    properties.setSpecular(true);
                }
            }
        }
        return properties;
    }

    private Collection<String> getTextureAttributes(String name) {
        String attrib = name.replaceAll(PATTERN, "$2");
        if (attrib.equals(name)) {
            return Collections.emptyList();
        }
        HashSet<String> results = new HashSet<String>();
        for (byte ch : attrib.getBytes(StandardCharsets.UTF_8)) {
            results.add(String.valueOf((char)ch));
        }
        return results;
    }

    public static class Resolution {
        public static void apply(TextureData data) {
            int base = Resolution.by(data);
            Collection<ITextureProvider> variants = data.getVariants();
            if (variants.isEmpty()) {
                data.setVariants(Collections.emptyList());
                return;
            }
            LinkedHashMap<Integer, ITextureProvider> secondaryTextures = new LinkedHashMap<Integer, ITextureProvider>();
            LinkedHashMap<Integer, List> additionalTextures = new LinkedHashMap<Integer, List>();
            secondaryTextures.put(base & 0xF0, data);
            for (ITextureProvider variant : variants) {
                int key2 = Resolution.by(variant);
                if ((key2 & 0xF) == 0) {
                    secondaryTextures.putIfAbsent(key2 & 0xF0, variant);
                    continue;
                }
                additionalTextures.computeIfAbsent(key2 & 0xF0, k -> new ArrayList()).add(variant);
            }
            secondaryTextures.forEach((key, provider) -> {
                if (provider instanceof TextureData) {
                    TextureData data1 = (TextureData)provider;
                    int used = Resolution.by(data1) & 0xF;
                    List values = additionalTextures.getOrDefault(key, new ArrayList());
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        int ck = Resolution.by((ITextureProvider)iterator.next()) & 0xF;
                        if ((used & ck) == ck) {
                            iterator.remove();
                        }
                        used |= ck;
                    }
                    data1.setVariants(values);
                }
            });
            ArrayList<ITextureProvider> newVariants = new ArrayList<ITextureProvider>(secondaryTextures.values());
            newVariants.remove(data);
            newVariants.addAll(data.getVariants());
            data.setVariants(newVariants);
        }

        public static int by(ITextureProvider data) {
            int key = 0;
            ITextureProperties properties = data.getProperties();
            if (properties.isEmissive()) {
                key |= 0x10;
            }
            if (properties.isParticle()) {
                key |= 0x20;
            }
            if (properties.isNormal()) {
                key |= 1;
            }
            if (properties.isSpecular()) {
                key |= 2;
            }
            return key;
        }
    }
}

