/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import org.apache.commons.lang3.tuple.Pair;

public class SkinPreviewData {
    private final Collection<Pair<ISkinTransform, SkinCubes>> allCubes;

    public SkinPreviewData(Collection<Pair<ISkinTransform, SkinCubes>> allCubes) {
        this.allCubes = allCubes;
    }

    public static SkinPreviewData of(Skin skin) {
        if (skin.getPreviewData() != null) {
            return skin.getPreviewData();
        }
        ArrayList<Pair<ISkinTransform, SkinCubes>> allCubes = new ArrayList<Pair<ISkinTransform, SkinCubes>>();
        SkinPreviewData.eachPart(skin.getParts(), part -> {
            IVector3i pos = part.getType().getRenderOffset();
            SkinTransform offset = SkinTransform.createTranslateTransform(pos.getX(), pos.getY(), pos.getZ());
            SkinPartTransform transform = new SkinPartTransform((SkinPart)part, offset);
            allCubes.add(Pair.of((Object)transform, (Object)part.getCubeData()));
        });
        return new SkinPreviewData(allCubes);
    }

    private static void eachPart(Collection<SkinPart> parts, Consumer<SkinPart> consumer) {
        for (SkinPart part : parts) {
            consumer.accept(part);
            SkinPreviewData.eachPart(part.getParts(), consumer);
        }
    }

    public void forEach(BiConsumer<ISkinTransform, SkinCubes> consumer) {
        this.allCubes.forEach((? super T pair) -> consumer.accept((ISkinTransform)pair.getKey(), (SkinCubes)pair.getValue()));
    }
}

