/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.core.texture.TextureAnimation;
import moe.plushie.armourers_workshop.core.texture.TextureProperties;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.ThreadUtils;

public class TextureData
implements ITextureProvider {
    private final int id = ThreadUtils.nextId(TextureData.class);
    private final String name;
    private final float width;
    private final float height;
    private TextureAnimation animation;
    private TextureProperties properties;
    private ByteBuffer bytes;
    private Collection<ITextureProvider> variants = Collections.emptyList();

    public TextureData(String name, float width, float height) {
        this(name, width, height, TextureAnimation.EMPTY, TextureProperties.EMPTY);
    }

    public TextureData(String name, float width, float height, TextureAnimation animation, TextureProperties properties) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.animation = animation;
        this.properties = properties;
    }

    public void load(ByteBuf buf) {
        this.bytes = ByteBuffer.allocateDirect(buf.readableBytes());
        buf.getBytes(0, this.bytes);
        this.bytes.rewind();
    }

    public void load(InputStream inputStream) throws IOException {
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel fileChannel = fileInputStream.getChannel();
            this.bytes = ObjectUtils.createByteBuffer((int)fileChannel.size() + 1);
            while (fileChannel.read(this.bytes) != -1) {
            }
            this.bytes.rewind();
            return;
        }
        int capacity = 16384;
        this.bytes = ObjectUtils.createByteBuffer(capacity);
        ArrayList buffers = Lists.newArrayList((Object[])new ByteBuffer[]{this.bytes});
        ReadableByteChannel byteChannel = Channels.newChannel(inputStream);
        while (byteChannel.read(this.bytes) != -1) {
            if (this.bytes.remaining() != 0) continue;
            this.bytes = ByteBuffer.allocate(capacity);
            capacity += this.bytes.capacity();
            buffers.add(this.bytes);
        }
        if (buffers.size() != 1) {
            int total = capacity - this.bytes.remaining();
            this.bytes = ObjectUtils.createByteBuffer(total);
            for (ByteBuffer buffer : buffers) {
                buffer.flip();
                this.bytes.put(buffer);
            }
        }
        this.bytes.flip();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setAnimation(TextureAnimation animation) {
        this.animation = animation;
    }

    @Override
    public TextureAnimation getAnimation() {
        return this.animation;
    }

    public void setProperties(TextureProperties properties) {
        this.properties = properties;
    }

    @Override
    public TextureProperties getProperties() {
        return this.properties;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.bytes;
    }

    public void setVariants(Collection<ITextureProvider> variants) {
        this.variants = variants;
    }

    @Override
    public Collection<ITextureProvider> getVariants() {
        return this.variants;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "name", this.name, "width", Float.valueOf(this.width), "height", Float.valueOf(this.height), "animation", this.animation, "properties", this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextureData)) {
            return false;
        }
        TextureData that = (TextureData)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

