/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import java.io.IOException;
import java.util.ArrayList;
import joptsimple.internal.Strings;
import moe.plushie.armourers_workshop.api.common.ITextureProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;

public class TextureProperties
implements ITextureProperties {
    public static final TextureProperties EMPTY = new TextureProperties();
    private int flags = 0;

    public void readFromStream(IInputStream stream) throws IOException {
        this.flags = stream.readInt();
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeInt(this.flags);
    }

    public void setEmissive(boolean isEmissive) {
        this.setFlag(0, isEmissive);
    }

    @Override
    public boolean isEmissive() {
        return this.getFlag(0);
    }

    public void setParticle(boolean isParticle) {
        this.setFlag(1, isParticle);
    }

    @Override
    public boolean isParticle() {
        return this.getFlag(1);
    }

    public void setSpecular(boolean isSpecular) {
        this.setFlag(2, isSpecular);
    }

    @Override
    public boolean isSpecular() {
        return this.getFlag(2);
    }

    public void setNormal(boolean isNormal) {
        this.setFlag(3, isNormal);
    }

    @Override
    public boolean isNormal() {
        return this.getFlag(3);
    }

    public String toString() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.isEmissive()) {
            values.add("Emissive");
        }
        if (this.isParticle()) {
            values.add("Particle");
        }
        if (this.isNormal()) {
            values.add("Normal");
        }
        if (this.isSpecular()) {
            values.add("Specular");
        }
        return String.format("[%s]", Strings.join(values, (String)","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextureProperties)) {
            return false;
        }
        TextureProperties that = (TextureProperties)o;
        return this.flags == that.flags;
    }

    public int hashCode() {
        return this.flags;
    }

    private void setFlag(int bit, boolean value) {
        this.flags = value ? (this.flags |= 1 << bit) : (this.flags &= ~(1 << bit));
    }

    private boolean getFlag(int bit) {
        return (this.flags & 1 << bit) != 0;
    }
}

