/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import moe.plushie.armourers_workshop.api.common.IArgumentSerializer;
import moe.plushie.armourers_workshop.api.common.IArgumentType;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.init.command.ColorParser;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.commands.CommandSourceStack;

public class ColorArgumentType
implements IArgumentType<PaintColor> {
    private static final Collection<String> EXAMPLES = ObjectUtils.map("[paintType:]#RRGGBB", "[paintType:]R,G,B");

    public static PaintColor getColor(CommandContext<CommandSourceStack> context, String name) {
        return (PaintColor)context.getArgument(name, PaintColor.class);
    }

    public PaintColor parse(StringReader reader) throws CommandSyntaxException {
        ColorParser parser = new ColorParser(reader).parse();
        return parser.getPaintColor();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ColorParser parser = new ColorParser(stringReader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return parser.fillSuggestions(builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Serializer
    implements IArgumentSerializer<ColorArgumentType> {
        @Override
        public void serializeToNetwork(ColorArgumentType argument, IFriendlyByteBuf buffer) {
        }

        @Override
        public ColorArgumentType deserializeFromNetwork(IFriendlyByteBuf buffer) {
            return new ColorArgumentType();
        }

        @Override
        public void serializeToJson(ColorArgumentType argument, JsonObject json) {
        }
    }
}

