/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.command.ColorParser;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;

public class ColorSchemeParser {
    public static final DynamicCommandExceptionType ERROR_INVALID_DYE_FORMAT = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"commands.armourers.invalidDyeFormat", (Object[])new Object[]{obj}));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private static final HashMap<String, ISkinPaintType> DYE_TYPES = (HashMap)Util.m_137537_(() -> {
        HashMap<String, SkinPaintType> map = new HashMap<String, SkinPaintType>();
        for (int i = 0; i < 8; ++i) {
            SkinPaintType paintType = SkinPaintTypes.byId(i + 1);
            String name = paintType.getRegistryName().getPath();
            map.put(name.replaceAll("_", ""), paintType);
        }
        return map;
    });
    private final StringReader reader;
    private final ColorParser colorParser;
    private final Map<ISkinPaintType, PaintColor> properties = Maps.newHashMap();
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    public ColorSchemeParser(StringReader stringReader) {
        this.reader = stringReader;
        this.colorParser = new ColorParser(stringReader);
    }

    public ColorSchemeParser parse() throws CommandSyntaxException {
        this.suggestions = this::suggestOpenProperties;
        if (this.reader.canRead() && this.reader.peek() == '<') {
            this.reader.skip();
            this.suggestions = this::suggestPropertyNameOrEnd;
            this.reader.skipWhitespace();
            while (this.reader.canRead() && this.reader.peek() != '>') {
                this.reader.skipWhitespace();
                int i = this.reader.getCursor();
                String string = this.reader.readString();
                ISkinPaintType property = DYE_TYPES.get(string);
                if (property == null) {
                    this.reader.setCursor(i);
                    throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)string);
                }
                if (this.properties.containsKey(string)) {
                    this.reader.setCursor(i);
                    throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)string);
                }
                this.reader.skipWhitespace();
                this.suggestions = this::suggestEquals;
                if (!this.reader.canRead() || this.reader.peek() != '=') {
                    throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)string);
                }
                this.reader.skip();
                this.reader.skipWhitespace();
                this.suggestions = this.colorParser::fillSuggestions;
                this.properties.put(property, this.colorParser.parse().getPaintColor());
                this.suggestions = this::suggestNextPropertyOrEnd;
                if (!this.reader.canRead()) break;
                if (this.reader.peek() == ' ') {
                    this.reader.skip();
                    this.suggestions = this::suggestPropertyName;
                    continue;
                }
                if (this.reader.peek() != '>') continue;
                break;
            }
            if (!this.reader.canRead()) {
                throw ERROR_INVALID_DYE_FORMAT.createWithContext((ImmutableStringReader)this.reader, (Object)this.reader.getString());
            }
            this.reader.skip();
            this.suggestions = SUGGEST_NOTHING;
        }
        return this;
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        return this.suggestions.apply(builder.createOffset(this.reader.getCursor()));
    }

    public Map<ISkinPaintType, PaintColor> getProperties() {
        return this.properties;
    }

    private CompletableFuture<Suggestions> suggestOpenProperties(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('<'));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNextPropertyOrEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('>'));
        }
        if (suggestionsBuilder.getRemaining().isEmpty() && this.properties.size() < DYE_TYPES.size()) {
            suggestionsBuilder.suggest(String.valueOf(' '));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestPropertyNameOrEnd(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('>'));
        }
        return this.suggestPropertyName(builder);
    }

    private CompletableFuture<Suggestions> suggestPropertyName(SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, ISkinPaintType> entry : DYE_TYPES.entrySet()) {
            String name = entry.getKey();
            if (this.properties.containsKey(entry.getValue()) || !name.startsWith(string)) continue;
            builder.suggest(name + "=");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }
}

