/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.registry.IEventHandler;
import moe.plushie.armourers_workshop.init.platform.forge.EventManagerImpl;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class EventManager {
    private static final HashMap<Class<?>, IEventHandler<?>> SOURCES = new HashMap();
    private static final HashMap<Class<?>, ArrayList<Consumer<?>>> HANDLERS = new HashMap();

    public static <E> void listen(Class<E> eventType, Consumer<E> subscriber) {
        IEventHandler<?> handler = SOURCES.get(eventType);
        if (handler != null) {
            handler.listen((Consumer)ObjectUtils.unsafeCast(subscriber));
        }
        HANDLERS.computeIfAbsent(eventType, key -> new ArrayList()).add(subscriber);
    }

    public static <E> void post(Class<? super E> eventType, E event) {
        ArrayList<Consumer<?>> handlers = HANDLERS.get(eventType);
        if (handlers != null) {
            handlers.forEach((Consumer<Consumer<?>>)((Consumer<Consumer>)it -> it.accept(ObjectUtils.unsafeCast(event))));
        }
    }

    public static <E> void post(Class<? super E> eventType, IEventHandler<E> handler) {
        SOURCES.put(eventType, handler);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void init() {
        EventManagerImpl.init();
    }

    static {
        EventManager.init();
    }
}

