/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import moe.plushie.armourers_workshop.api.registry.IBlockBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryBinder;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.compatibility.api.AbstractBlockMaterial;
import moe.plushie.armourers_workshop.compatibility.api.AbstractBlockMaterialColor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.state.BlockBehaviour.Constructor;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBuilderImpl<T extends Block>
implements IBlockBuilder<T> {
    private BlockBehaviour.Properties properties;
    private IRegistryBinder<T> binder;
    private final Function<BlockBehaviour.Properties, T> supplier;

    public BlockBuilderImpl(Function<BlockBehaviour.Properties, T> supplier, AbstractBlockMaterial material, AbstractBlockMaterialColor materialColor) {
        this.properties = Constructor.Properties.of(BlockBehaviour.Properties.class, material, materialColor);
        this.supplier = supplier;
    }

    @Override
    public IBlockBuilder<T> noCollission() {
        this.properties = this.properties.m_60910_();
        return this;
    }

    @Override
    public IBlockBuilder<T> noOcclusion() {
        this.properties = this.properties.m_60955_();
        return this;
    }

    @Override
    public IBlockBuilder<T> friction(float f) {
        this.properties = this.properties.m_60911_(f);
        return this;
    }

    @Override
    public IBlockBuilder<T> speedFactor(float f) {
        this.properties = this.properties.m_60956_(f);
        return this;
    }

    @Override
    public IBlockBuilder<T> jumpFactor(float f) {
        this.properties = this.properties.m_60967_(f);
        return this;
    }

    @Override
    public IBlockBuilder<T> sound(SoundType soundType) {
        this.properties = this.properties.m_60918_(soundType);
        return this;
    }

    @Override
    public IBlockBuilder<T> lightLevel(ToIntFunction<BlockState> toIntFunction) {
        this.properties = this.properties.m_60953_(toIntFunction);
        return this;
    }

    @Override
    public IBlockBuilder<T> strength(float f, float g) {
        this.properties = this.properties.m_60913_(f, g);
        return this;
    }

    @Override
    public IBlockBuilder<T> randomTicks() {
        this.properties = this.properties.m_60977_();
        return this;
    }

    @Override
    public IBlockBuilder<T> dynamicShape() {
        this.properties = this.properties.m_60988_();
        return this;
    }

    @Override
    public IBlockBuilder<T> noDrops() {
        this.properties = this.properties.m_222994_();
        return this;
    }

    @Override
    public IBlockBuilder<T> air() {
        this.properties = this.properties.m_60996_();
        return this;
    }

    @Override
    public IBlockBuilder<T> forceSolid() {
        this.properties = this.properties.m_280606_();
        return this;
    }

    @Override
    public IBlockBuilder<T> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> stateArgumentPredicate) {
        this.properties = this.properties.m_60922_(stateArgumentPredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> isRedstoneConductor(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.m_60924_(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> isSuffocating(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.m_60960_(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> isViewBlocking(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.m_60971_(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> hasPostProcess(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.m_60982_(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> emissiveRendering(BlockBehaviour.StatePredicate statePredicate) {
        this.properties = this.properties.m_60991_(statePredicate);
        return this;
    }

    @Override
    public IBlockBuilder<T> requiresCorrectToolForDrops() {
        this.properties = this.properties.m_60999_();
        return this;
    }

    @Override
    public IBlockBuilder<T> bind(Supplier<Supplier<RenderType>> provider) {
        this.binder = () -> arg_0 -> BlockBuilderImpl.lambda$bind$0((Supplier)provider, arg_0);
        return this;
    }

    @Override
    public IRegistryHolder<T> build(String name) {
        IRegistryHolder<Block> object = AbstractForgeRegistries.BLOCKS.register(name, () -> (Block)this.supplier.apply(this.properties));
        EnvironmentExecutor.didInit(EnvironmentType.CLIENT, IRegistryBinder.perform(this.binder, object));
        return object;
    }

    private static /* synthetic */ void lambda$bind$0(Supplier provider, IRegistryHolder block) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)((RenderType)((Supplier)provider.get()).get()));
    }
}

