/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.registry.IEntityTypeBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryBinder;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.EntityType.Constructor;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.client.renderer.GameRenderer.ForgeRegistry;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class EntityTypeBuilderImpl<T extends Entity>
implements IEntityTypeBuilder<T> {
    private EntityType.Builder<T> builder;
    private IRegistryBinder<EntityType<T>> binder;

    public EntityTypeBuilderImpl(IEntityType.Serializer<T> serializer, MobCategory mobCategory) {
        this.builder = EntityType.Builder.m_20704_(serializer::create, (MobCategory)mobCategory);
    }

    @Override
    public IEntityTypeBuilder<T> fixed(float f, float g) {
        this.builder = this.builder.m_20699_(f, g);
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> noSummon() {
        this.builder = this.builder.m_20698_();
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> noSave() {
        this.builder = this.builder.m_20716_();
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> fireImmune() {
        this.builder = this.builder.m_20719_();
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> specificSpawnBlocks(Block ... blocks) {
        this.builder = this.builder.m_20714_(blocks);
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.builder = this.builder.m_20720_();
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> clientTrackingRange(int i) {
        this.builder = this.builder.m_20702_(i);
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> updateInterval(int i) {
        this.builder = this.builder.m_20717_(i);
        return this;
    }

    @Override
    public IEntityTypeBuilder<T> bind(Supplier<AbstractEntityRendererProvider<T>> provider) {
        this.binder = () -> arg_0 -> EntityTypeBuilderImpl.lambda$bind$0((Supplier)provider, arg_0);
        return this;
    }

    @Override
    public IRegistryHolder<IEntityType<T>> build(String name) {
        IRegistryHolder object = AbstractForgeRegistries.ENTITY_TYPES.register(name, () -> this.builder.m_20712_(name));
        Proxy proxy = new Proxy(object);
        EnvironmentExecutor.willInit(EnvironmentType.CLIENT, IRegistryBinder.perform(this.binder, object));
        return TypedRegistry.Entry.of(object.getRegistryName(), () -> proxy);
    }

    private static /* synthetic */ void lambda$bind$0(Supplier provider, IRegistryHolder entityType) {
        ForgeRegistry.registerEntityRendererFO(GameRenderer.class, entityType, (AbstractEntityRendererProvider)provider.get());
    }

    public static class Proxy<T extends Entity>
    implements IEntityType<T> {
        private final IRegistryHolder<EntityType<T>> object;

        public Proxy(IRegistryHolder<EntityType<T>> object) {
            this.object = object;
        }

        @Override
        public T create(ServerLevel level, BlockPos pos, @Nullable ItemStack itemStack, MobSpawnType spawnType) {
            return Constructor.create((EntityType)this.object.get(), level, pos, itemStack, spawnType);
        }

        @Override
        public EntityType<T> get() {
            return (EntityType)this.object.get();
        }
    }
}

