/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.common.IItemGroupProvider;
import moe.plushie.armourers_workshop.api.registry.IItemGroupBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryHolder;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.world.item.CreativeModeTab.BuilderProvider;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemGroupBuilderImpl<T extends IItemGroup>
implements IItemGroupBuilder<T> {
    private Supplier<Supplier<ItemStack>> icon = () -> () -> ItemStack.f_41583_;

    @Override
    public IItemGroupBuilder<T> icon(Supplier<Supplier<ItemStack>> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public IRegistryHolder<T> build(String name) {
        ItemGroup group = new ItemGroup(name);
        return TypedRegistry.Entry.cast(ModConstants.key(name), () -> group);
    }

    public class ItemGroup
    implements IItemGroup {
        private final IRegistryHolder<CreativeModeTab> tab;
        private final ArrayList<Supplier<Item>> items = new ArrayList();

        public ItemGroup(String name) {
            this.tab = AbstractForgeRegistries.ITEM_GROUPS.register(name, BuilderProvider.createCreativeModeTabFO(CreativeModeTab.class, name, ItemGroupBuilderImpl.this.icon, this::fill));
        }

        public void fill(List<ItemStack> results) {
            for (Supplier<Item> itemProvider : this.items) {
                Item item = itemProvider.get();
                results.add(item.m_7968_());
                IItemGroupProvider provider = ObjectUtils.safeCast(item, IItemGroupProvider.class);
                if (provider == null) continue;
                provider.fillItemGroup(results, this);
            }
        }

        @Override
        public void add(Supplier<Item> item) {
            this.items.add(item);
        }

        @Override
        public CreativeModeTab get() {
            return (CreativeModeTab)this.tab.get();
        }
    }
}

