/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import java.util.stream.Stream;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.client.render.PaintingHighlightPlacementRenderer;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Wrapper;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.animation.AnimationEngine;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.bake.SkinPreloadManager;
import moe.plushie.armourers_workshop.core.client.render.HighlightPlacementRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import moe.plushie.armourers_workshop.core.client.texture.TextureManager;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.cache.AutoreleasePool;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.client.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.EventManager;
import moe.plushie.armourers_workshop.init.platform.ItemTooltipManager;
import moe.plushie.armourers_workshop.init.platform.event.client.ClientPlayerEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.ItemTooltipEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RegisterColorHandlersEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RegisterItemPropertyEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RegisterModelEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RegisterTextureEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RenderFrameEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RenderHighlightEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RenderLivingEntityEvent;
import moe.plushie.armourers_workshop.init.platform.event.client.RenderSpecificHandEvent;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.impl.MinecraftAuth;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import moe.plushie.armourers_workshop.utils.ext.OpenResourceLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy {
    public static void init() {
        MinecraftAuth.init(() -> Minecraft.m_91087_().m_91094_().m_92545_(), () -> Minecraft.m_91087_().m_91094_().m_92547_());
        ClientWardrobeHandler.init();
        SkinRendererManager2.init();
        ModKeyBindings.init();
        ModDebugger.init();
        EnvironmentExecutor.willSetup(EnvironmentType.CLIENT, () -> () -> {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            DataPackLoader packLoader = DataPackManager.byType(DataPackType.CLIENT_RESOURCES);
            ((ReloadableResourceManager)resourceManager).m_7217_((PreparableReloadListener)packLoader);
        });
        ClientProxy.register();
    }

    private static void register() {
        EventManager.listen(RegisterItemPropertyEvent.class, event -> TypedRegistry.findEntries(Item.class).forEach(it -> {
            Item item = (Item)it.get();
            if (item instanceof IItemPropertiesProvider) {
                IItemPropertiesProvider provider = (IItemPropertiesProvider)item;
                provider.createModelProperties((key, property) -> event.register((IResourceLocation)key, item, (IItemModelProperty)property));
            }
            event.register(ModConstants.key("type"), Items.f_42717_, (itemStack, level, entity, id) -> 1.0f);
        }));
        EventManager.listen(RegisterColorHandlersEvent.Item.class, event -> TypedRegistry.findEntries(Item.class).forEach(it -> {
            Item item = (Item)it.get();
            if (item instanceof IItemTintColorProvider) {
                IItemTintColorProvider provider = (IItemTintColorProvider)item;
                event.register(provider, item);
            }
        }));
        EventManager.listen(RegisterColorHandlersEvent.Block.class, event -> TypedRegistry.findEntries(Block.class).forEach(it -> {
            Block block = (Block)it.get();
            if (block instanceof IBlockTintColorProvider) {
                IBlockTintColorProvider provider = (IBlockTintColorProvider)block;
                event.register(provider, block);
            }
        }));
        EventManager.listen(RegisterModelEvent.class, event -> SkinPartTypes.registeredTypes().forEach(partType -> {
            IResourceLocation rl = ArmourersWorkshop.getCustomModel(partType.getRegistryName());
            IResourceManager resourceManager = Wrapper.asResourceManager(Minecraft.m_91087_().m_91098_());
            if (resourceManager.hasResource(OpenResourceLocation.create(rl.getNamespace(), "models/item/" + rl.getPath() + ".json"))) {
                event.register(rl);
            }
        }));
        EventManager.listen(RegisterTextureEvent.class, event -> Stream.of(SkinSlotType.values()).forEach(slotType -> event.register(slotType.getIconSprite())));
        EventManager.listen(ClientPlayerEvent.LoggingIn.class, event -> {
            Player player = event.getPlayer();
            if (player == null || !player.equals((Object)EnvironmentManager.getPlayer())) {
                return;
            }
            SkinBakery.start();
            SkinPreloadManager.start();
            TextureManager.getInstance().start();
            AnimationEngine.start();
        });
        EventManager.listen(ClientPlayerEvent.LoggingOut.class, event -> {
            Player player = event.getPlayer();
            if (player != null && !player.equals((Object)EnvironmentManager.getPlayer())) {
                return;
            }
            AnimationEngine.stop();
            SkinPreloadManager.stop();
            SkinBakery.stop();
            Tickets.invalidateAll();
            TextureManager.getInstance().stop();
            SkinLoader.getInstance().stop();
            GlobalSkinLibrary.getInstance().disconnect();
            SkinLibraryManager.getClient().getPublicSkinLibrary().reset();
            SkinLibraryManager.getClient().getPrivateSkinLibrary().reset();
            ModContext.reset();
            ModConfigSpec.COMMON.apply(null);
        });
        EventManager.listen(ClientPlayerEvent.Clone.class, event -> {
            SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)event.getOldPlayer());
            SkinWardrobe newWardrobe = SkinWardrobe.of((Entity)event.getNewPlayer());
            if (newWardrobe != null && oldWardrobe != null) {
                CompoundTag tag = new CompoundTag();
                oldWardrobe.serialize(AbstractDataSerializer.wrap(tag, event.getPlayer()));
                newWardrobe.deserialize(AbstractDataSerializer.wrap(tag, event.getPlayer()));
            }
        });
        EventManager.listen(RenderFrameEvent.Pre.class, event -> {
            AutoreleasePool.begin();
            TickUtils.tick(event.isPaused() || event.isFrozen());
            SkinPreloadManager.tick(event.isPaused());
        });
        EventManager.listen(RenderFrameEvent.Post.class, event -> AutoreleasePool.end());
        EventManager.listen(RenderHighlightEvent.Block.class, event -> {
            Player player = EnvironmentManager.getPlayer();
            if (player == null) {
                return;
            }
            IPoseStack poseStack = AbstractPoseStack.wrap(event.getPoseStack());
            AbstractBufferSource buffers = AbstractBufferSource.wrap(event.getMultiBufferSource());
            ItemStack itemStack = player.m_21205_();
            if (ModConfig.Client.enableEntityPlacementHighlight && itemStack.m_150930_((Item)ModItems.MANNEQUIN.get())) {
                HighlightPlacementRenderer.renderEntity(player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
            if (ModConfig.Client.enableBlockPlacementHighlight && itemStack.m_150930_((Item)ModItems.SKIN.get())) {
                HighlightPlacementRenderer.renderBlock(itemStack, player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
            if (ModConfig.Client.enablePaintToolPlacementHighlight && itemStack.m_150930_((Item)ModItems.BLENDING_TOOL.get())) {
                PaintingHighlightPlacementRenderer.renderPaintTool(itemStack, player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
        });
        EventManager.listen(RenderLivingEntityEvent.Pre.class, event -> ClientWardrobeHandler.onRenderLivingEntityPre(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventManager.listen(RenderLivingEntityEvent.Setup.class, event -> ClientWardrobeHandler.onRenderLivingEntity(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventManager.listen(RenderLivingEntityEvent.Post.class, event -> ClientWardrobeHandler.onRenderLivingEntityPost(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventManager.listen(RenderSpecificHandEvent.class, event -> {
            if (!ModConfig.enableFirstPersonSkinRenderer()) {
                return;
            }
            AbstractItemTransformType transformType = AbstractItemTransformType.FIRST_PERSON_LEFT_HAND;
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                transformType = AbstractItemTransformType.FIRST_PERSON_RIGHT_HAND;
            }
            ClientWardrobeHandler.onRenderSpecificHand((LivingEntity)event.getPlayer(), 0.0f, event.getPackedLight(), transformType, event.getPoseStack(), event.getMultiBufferSource(), () -> event.setCancelled(true));
        });
        EventManager.listen(ItemTooltipEvent.Gather.class, ItemTooltipManager::gatherSkinTooltip);
        EventManager.listen(ItemTooltipEvent.Render.class, ItemTooltipManager::renderSkinTooltip);
    }
}

