/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractDataSerializer;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.DataManager;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.TickTracker;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinServerType;
import moe.plushie.armourers_workshop.init.ModCommands;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.network.UpdateContextPacket;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.EventManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import moe.plushie.armourers_workshop.init.platform.event.common.BlockEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.PlayerEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.RegisterCommandsEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.RegisterDataPackEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.RegisterEntityAttributesEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.ServerLevelAddEntityEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.ServerLevelTickEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.ServerStartedEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.ServerStartingEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.ServerStoppedEvent;
import moe.plushie.armourers_workshop.init.platform.event.common.ServerStoppingEvent;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CommonProxy {
    public static void init() {
        CommonProxy.setup();
        CommonProxy.register();
    }

    private static void setup() {
        GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER, library::downloadSkin);
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER_PREVIEW, library::downloadPreviewSkin);
        ReplayManager.init();
    }

    private static void register() {
        EventManager.listen(RegisterCommandsEvent.class, ModCommands::init);
        EventManager.listen(RegisterDataPackEvent.class, event -> event.register(DataPackManager.byType(DataPackType.SERVER_DATA)));
        EventManager.listen(RegisterEntityAttributesEvent.class, event -> {
            event.register((EntityType<? extends LivingEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), MannequinEntity.m_21183_());
            event.register((EntityType<? extends LivingEntity>)((EntityType)((IEntityType)ModEntityTypes.SEAT.get()).get()), SeatEntity.m_21183_());
        });
        EventManager.listen(ServerStartingEvent.class, event -> {
            ModLog.debug("hello", new Object[0]);
            DataManager.getInstance().connect(EnvironmentManager.getSkinDatabaseDirectory());
            SkinLoader.getInstance().prepare(SkinServerType.of(event.getServer()));
        });
        EventManager.listen(ServerStartedEvent.class, event -> {
            ModLog.debug("init", new Object[0]);
            ModContext.init(event.getServer());
            SkinLoader.getInstance().start();
        });
        EventManager.listen(ServerStoppingEvent.class, event -> {
            ModLog.debug("wait", new Object[0]);
            for (ServerLevel level : event.getServer().m_129785_()) {
                WorldUpdater.getInstance().drain((Level)level);
            }
            DataManager.getInstance().disconnect();
            SkinLoader.getInstance().stop();
        });
        EventManager.listen(ServerStoppedEvent.class, event -> {
            ModLog.debug("bye", new Object[0]);
            ModContext.reset();
        });
        EventManager.listen(PlayerEvent.LoggingIn.class, event -> {
            ModLog.debug("welcome back {}", event.getPlayer().m_6302_());
            ModHolidays.welcome(event.getPlayer());
            ReplayManager.startRecording(event.getPlayer().m_20194_(), event.getPlayer());
            Player patt0$temp = event.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                NetworkManager.sendTo(new UpdateContextPacket((Player)player), player);
                NetworkManager.sendWardrobeTo((Entity)player, player);
            }
        });
        EventManager.listen(PlayerEvent.LoggingOut.class, event -> {
            ModLog.debug("good bye {}", event.getPlayer().m_6302_());
            SkinLibraryManager.getServer().remove(event.getPlayer());
            ReplayManager.stopRecording(event.getPlayer().m_20194_(), event.getPlayer());
        });
        EventManager.listen(PlayerEvent.Death.class, event -> {
            ModLog.debug("keep careful {}", event.getPlayer().m_6302_());
            SkinUtils.dropAllIfNeeded(event.getPlayer());
        });
        EventManager.listen(PlayerEvent.Clone.class, event -> {
            ModLog.debug("woa {}", event.getPlayer().m_6302_());
            SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)event.getOriginal());
            SkinWardrobe newWardrobe = SkinWardrobe.of((Entity)event.getPlayer());
            if (newWardrobe != null && oldWardrobe != null) {
                CompoundTag tag = new CompoundTag();
                oldWardrobe.serialize(AbstractDataSerializer.wrap(tag, event.getPlayer()));
                newWardrobe.deserialize(AbstractDataSerializer.wrap(tag, event.getPlayer()));
                newWardrobe.broadcast();
            }
        });
        EventManager.listen(PlayerEvent.Attack.class, event -> {
            InteractionResult result;
            Player player = event.getPlayer();
            if (player == null || player.m_5833_()) {
                return;
            }
            ItemStack itemStack = player.m_21205_();
            IItemHandler handler = ObjectUtils.safeCast(itemStack.m_41720_(), IItemHandler.class);
            if (handler != null && (result = handler.attackLivingEntity(itemStack, player, event.getTarget())).m_19077_()) {
                event.setCancelled(true);
            }
        });
        EventManager.listen(PlayerEvent.StartTracking.class, event -> {
            EntityProfile entityProfile = ModEntityProfiles.getProfile(event.getTarget());
            if (entityProfile != null) {
                NetworkManager.sendWardrobeTo(event.getTarget(), (ServerPlayer)event.getPlayer());
            }
        });
        EventManager.listen(ServerLevelTickEvent.Pre.class, event -> {
            TickTracker.server().update(false);
            WorldUpdater.getInstance().tick((Level)event.getLevel());
        });
        EventManager.listen(ServerLevelAddEntityEvent.class, event -> SkinUtils.copySkinFromOwner(event.getEntity()));
        EventManager.listen(BlockEvent.Place.class, BlockUtils::snapshot);
        EventManager.listen(BlockEvent.Break.class, BlockUtils::snapshot);
    }
}

