/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import com.apple.library.uikit.UIView;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.InputDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinComboBox;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinFileList;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.menu.SkinLibraryMenu;
import moe.plushie.armourers_workshop.library.network.SaveSkinPacket;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinLibraryWindow
extends MenuWindow<SkinLibraryMenu>
implements UITextFieldDelegate,
ISkinLibraryListener {
    private final UICheckBox trackCheckBox = new UICheckBox(CGRect.ZERO);
    private final UIButton actionButton = new UIButton(CGRect.ZERO);
    private final UIButton localFileButton = this.buildIconButton(0, 0, 0, 0, 50, 30);
    private final UIButton remotePublicButton = this.buildIconButton(55, 0, 0, 31, 50, 30);
    private final UIButton remotePrivateButton = this.buildIconButton(110, 0, 0, 62, 50, 30);
    private final UIButton openFolderButton = this.buildIconButton(0, 0, 0, 93, 24, 24);
    private final UIButton deleteButton = this.buildIconButton(25, 0, 0, 118, 24, 24);
    private final UIButton refreshButton = this.buildIconButton(50, 0, 73, 93, 24, 24);
    private final UIButton newFolderButton = this.buildIconButton(75, 0, 73, 118, 24, 24);
    private final UIButton backButton = this.buildIconButton(138, 0, 146, 93, 24, 24);
    private final UITextField nameTextField = new UITextField(CGRect.ZERO);
    private final UITextField searchTextField = new UITextField(CGRect.ZERO);
    private final SkinComboBox skinTypeList = new SkinComboBox(CGRect.ZERO);
    private final SkinFileList fileList = new SkinFileList(new CGRect(0.0f, 0.0f, 100.0f, 100.0f));
    private final HashMap<String, CGPoint> contentOffsets = new HashMap();
    protected ISkinType skinType = SkinTypes.UNKNOWN;
    protected ISkinLibrary.Entry selectedFile = null;
    protected String selectedPath;
    protected ItemStack lastInputItem;
    protected SkinLibrary selectedLibrary;
    protected SkinLibraryManager.Client libraryManager = SkinLibraryManager.getClient();
    private final Inventory playerInventory;

    public SkinLibraryWindow(SkinLibraryMenu container, Inventory inventory, NSString title) {
        super(container, inventory, title);
        this.setFrame(new CGRect(0.0f, 0.0f, 640.0f, 480.0f));
        this.libraryManager.addListener(this);
        this.selectedLibrary = this.libraryManager.getLocalSkinLibrary();
        this.selectedPath = this.selectedLibrary.getRootPath();
        this.playerInventory = inventory;
        this.inventoryView.removeFromSuperview();
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
        ((SkinLibraryMenu)this.menu).reload(0, 0, (int)size.width, (int)size.height);
    }

    @Override
    public void init() {
        super.init();
        CGRect rect = this.bounds().insetBy(23.0f, 5.0f, 5.0f, 5.0f);
        this.titleView.setTextColor(new UIColor(0xCCCCCC));
        this.setupInputView(rect);
        this.setupInventoryView(rect);
        this.setupFileView(rect.insetBy(0.0f, 167.0f, 0.0f, 0.0f));
        this.reloadData(this);
        this.reloadStatus();
    }

    @Override
    public void menuDidChange() {
        super.menuDidChange();
        this.reloadStatus();
        this.reloadInputName();
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.renameItem(textField.text());
        return true;
    }

    private void setupInputView(CGRect rect) {
        int width = 162;
        UIView group1 = new UIView(new CGRect(rect.getMinX(), rect.getMinY(), width, 30.0f));
        this.addSubview(group1);
        this.localFileButton.setTooltip(this.getDisplayText("rollover.localFiles", new Object[0]), 4);
        this.localFileButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::selectLibrary);
        group1.addSubview(this.localFileButton);
        this.remotePublicButton.setTooltip(this.getDisplayText("rollover.notOnServer", new Object[0]), 4);
        this.remotePublicButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::selectLibrary);
        group1.addSubview(this.remotePublicButton);
        this.remotePrivateButton.setTooltip(this.getDisplayText("rollover.notOnServer", new Object[0]), 4);
        this.remotePrivateButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::selectLibrary);
        group1.addSubview(this.remotePrivateButton);
        this.nameTextField.setFrame(new CGRect(rect.getMinX(), group1.frame().getMaxY() + 5.0f, width, 20.0f));
        this.nameTextField.setPlaceholder(this.getDisplayText("label.enterFileName", new Object[0]));
        this.nameTextField.setMaxLength(255);
        this.nameTextField.setDelegate(this);
        this.addSubview(this.nameTextField);
        UIView group3 = new UIView(new CGRect(rect.getMinX(), this.nameTextField.frame().getMaxY() + 5.0f, width, 24.0f));
        this.addSubview(group3);
        this.openFolderButton.setTooltip(this.getDisplayText("rollover.openLibraryFolder", new Object[0]), 0);
        this.openFolderButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::openFolder);
        group3.addSubview(this.openFolderButton);
        this.refreshButton.setTooltip(this.getDisplayText("rollover.refresh", new Object[0]), 0);
        this.refreshButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::refreshLibrary);
        group3.addSubview(this.refreshButton);
        this.deleteButton.setTooltip(this.getDisplayText("rollover.deleteSkin", new Object[0]), 0);
        this.deleteButton.setTooltip(this.getDisplayText("rollover.deleteSkinSelect", new Object[0]), 4);
        this.deleteButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::removeItem);
        group3.addSubview(this.deleteButton);
        this.newFolderButton.setTooltip(this.getDisplayText("rollover.newFolder", new Object[0]), 0);
        this.newFolderButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::addFolder);
        group3.addSubview(this.newFolderButton);
        this.backButton.setTooltip(this.getDisplayText("rollover.back", new Object[0]), 0);
        this.backButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::backFolder);
        group3.addSubview(this.backButton);
    }

    private void setupInventoryView(CGRect rect) {
        int width = 162;
        int height = 76;
        UIView group1 = new UIView(new CGRect(rect.getMinX(), rect.getMaxY() - (float)height, width, height));
        group1.setOpaque(false);
        group1.setAutoresizingMask(8);
        group1.setContents(UIImage.of(ModTextures.SKIN_LIBRARY).uv(0.0f, 180.0f).build());
        this.addSubview(group1);
        UIView group2 = new UIView(new CGRect(rect.getMinX(), group1.frame().getMinY() - 31.0f, width, 26.0f));
        group2.setAutoresizingMask(8);
        this.addSubview(group2);
        this.trackCheckBox.setFrame(new CGRect(rect.getMinX(), group2.frame().getMinY() - 10.0f, width, 10.0f));
        this.trackCheckBox.setTitle(this.getDisplayText("trackFile", new Object[0]));
        this.trackCheckBox.setTitleColor(UIColor.WHITE);
        this.trackCheckBox.setSelected(false);
        this.trackCheckBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> self.reloadStatus());
        this.trackCheckBox.setAutoresizingMask(8);
        this.addSubview(this.trackCheckBox);
        this.actionButton.setTitleColor(UIColor.WHITE, 7);
        this.actionButton.setTitle(this.getDisplayText("load", new Object[0]), 7);
        this.actionButton.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        this.actionButton.setFrame(new CGRect(23.0f, 4.0f, width - 54, 20.0f));
        this.actionButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinLibraryWindow::loadOrSaveItem);
        group2.addSubview(this.actionButton);
        UIImageView bg2 = new UIImageView(new CGRect(0.0f, 4.0f, 18.0f, 18.0f));
        UIImageView bg3 = new UIImageView(new CGRect(width - 26, 0.0f, 26.0f, 26.0f));
        bg2.setOpaque(false);
        bg3.setOpaque(false);
        bg2.setImage(UIImage.of(ModTextures.SKIN_LIBRARY).uv(0.0f, 162.0f).build());
        bg3.setImage(UIImage.of(ModTextures.SKIN_LIBRARY).uv(18.0f, 154.0f).build());
        group2.addSubview(bg2);
        group2.addSubview(bg3);
    }

    private void setupFileView(CGRect rect) {
        float width = rect.getWidth();
        UIView group1 = new UIView(new CGRect(rect.getMinX(), rect.getMinY(), width, 20.0f));
        group1.setAutoresizingMask(2);
        this.addSubview(group1);
        this.fileList.setFrame(rect.insetBy(22.0f, 0.0f, 0.0f, 0.0f));
        this.fileList.setAutoresizingMask(18);
        this.fileList.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinLibraryWindow::selectFile);
        this.addSubview(this.fileList);
        this.searchTextField.setFrame(new CGRect(0.0f, 2.0f, width - 86.0f, 16.0f));
        this.searchTextField.setPlaceholder(this.getDisplayText("label.typeToSearch", new Object[0]));
        this.searchTextField.setAutoresizingMask(2);
        this.searchTextField.setMaxLength(255);
        this.searchTextField.addTarget(this, UIControl.Event.VALUE_CHANGED, SkinLibraryWindow::reloadData);
        group1.addSubview(this.searchTextField);
        this.skinTypeList.setFrame(new CGRect(rect.getMaxX() - 80.0f, rect.getMinY() + 2.0f, 80.0f, 16.0f));
        this.skinTypeList.setMaxRows(12);
        this.skinTypeList.setAutoresizingMask(1);
        this.skinTypeList.reloadSkins(SkinTypes.values());
        this.skinTypeList.setSelectedSkin(this.skinType);
        this.skinTypeList.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            self.skinType = self.skinTypeList.selectedSkin();
            self.reloadData(c);
        });
        this.addSubview(this.skinTypeList);
    }

    @Override
    public void deinit() {
        super.deinit();
        this.libraryManager.removeListener(this);
    }

    @Override
    public void libraryDidReload(ISkinLibrary library) {
        RenderSystem.recordRenderCall(() -> {
            if (this.selectedLibrary == library) {
                this.reloadData(this);
            }
            this.reloadStatus();
        });
    }

    public void reloadStatus() {
        boolean isFile = this.selectedFile != null && (!this.selectedFile.isDirectory() || !this.selectedFile.getName().equals(".."));
        boolean isLoadable = isFile && !this.selectedFile.isDirectory();
        boolean isAuthorized = this.isAuthorized();
        this.remotePublicButton.setEnabled(this.libraryManager.getPublicSkinLibrary().isReady());
        this.remotePrivateButton.setEnabled(this.libraryManager.getPrivateSkinLibrary().isReady());
        this.deleteButton.setEnabled(isAuthorized && isFile);
        this.newFolderButton.setEnabled(isAuthorized);
        this.openFolderButton.setEnabled(this.libraryManager.getLocalSkinLibrary() == this.selectedLibrary);
        if (this.hasInputSkin()) {
            this.actionButton.setEnabled(true);
            this.actionButton.setTitle(this.getDisplayText("save", new Object[0]), 7);
        } else {
            this.actionButton.setEnabled(isLoadable);
            this.actionButton.setTitle(this.getDisplayText("load", new Object[0]), 7);
        }
    }

    public void reloadInputName() {
        ItemStack itemStack = ((SkinLibraryMenu)this.menu).getInputStack();
        if (this.lastInputItem == itemStack) {
            return;
        }
        this.lastInputItem = itemStack;
        String name = null;
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.RENDERER);
        if (bakedSkin != null) {
            name = bakedSkin.getSkin().getCustomName();
        }
        this.nameTextField.setText(Strings.nullToEmpty((String)name));
    }

    public void reloadData(Object value) {
        String keyword = this.searchTextField.text();
        ArrayList<SkinLibraryFile> results = this.selectedLibrary.search(keyword, this.skinType, this.selectedPath);
        this.fileList.setSelectedItem(null);
        this.fileList.reloadData(new ArrayList<ISkinLibrary.Entry>(results));
        this.fileList.setContentOffset(this.contentOffsets.getOrDefault(this.selectedPath, CGPoint.ZERO));
    }

    private NSString getDisplayText(String key, Object ... args) {
        return NSString.localizedString("skin-library." + key, args);
    }

    private void selectLibrary(UIControl sender) {
        SkinLibrary newLibrary = this.libraryManager.getLocalSkinLibrary();
        if (sender == this.remotePublicButton) {
            newLibrary = this.libraryManager.getPublicSkinLibrary();
        }
        if (sender == this.remotePrivateButton) {
            newLibrary = this.libraryManager.getPrivateSkinLibrary();
            newLibrary.setRootPath("/private/" + ((SkinLibraryMenu)this.menu).getPlayer().m_20149_());
        }
        if (!newLibrary.isReady()) {
            newLibrary = this.libraryManager.getLocalSkinLibrary();
        }
        this.contentOffsets.clear();
        this.selectedLibrary = newLibrary;
        this.setSelectedPath(newLibrary.getRootPath());
        if (this.isAuthorized()) {
            this.deleteButton.setTooltip(this.getDisplayText("rollover.deleteSkinSelect", new Object[0]), 4);
            this.newFolderButton.setTooltip(null, 4);
        } else {
            this.deleteButton.setTooltip(this.getDisplayText("rollover.unauthorized", new Object[0]), 4);
            this.newFolderButton.setTooltip(this.getDisplayText("rollover.unauthorized", new Object[0]), 4);
        }
        this.libraryDidReload(newLibrary);
    }

    private void addFolder(UIControl sender) {
        InputDialog dialog = new InputDialog();
        dialog.setTitle(this.getDisplayText("dialog.newFolder.title", new Object[0]));
        dialog.setMessageColor(new UIColor(0xFF5555));
        dialog.setPlaceholder(this.getDisplayText("dialog.newFolder.enterFolderName", new Object[0]));
        dialog.setMessage(this.getDisplayText("dialog.newFolder.invalidFolderName", new Object[0]));
        dialog.setConfirmText(this.getDisplayText("dialog.newFolder.create", new Object[0]));
        dialog.setCancelText(this.getDisplayText("dialog.newFolder.close", new Object[0]));
        dialog.setVerifier(value -> value.replaceAll("[:\\\\/]|^[.]+$", "_").equals(value));
        dialog.showInView(this, () -> {
            if (!dialog.isCancelled()) {
                String newPath = SkinFileUtils.normalize(SkinFileUtils.concat(this.selectedPath, dialog.value()), true);
                this.selectedLibrary.mkdir(newPath);
            }
        });
    }

    private void openFolder(UIControl sender) {
        Util.m_137581_().m_137644_(EnvironmentManager.getSkinLibraryDirectory());
    }

    private void backFolder(UIControl sender) {
        ISkinLibrary.Entry entry = this.fileList.getItem(0);
        if (entry != null && entry.isDirectory() && entry.getName().equals("..")) {
            this.setSelectedPath(entry.getPath());
            this.reloadData(sender);
        }
    }

    private void loadOrSaveItem(UIControl button) {
        if (!((SkinLibraryMenu)this.menu).getOutputStack().m_41619_()) {
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(((SkinLibraryMenu)this.menu).getInputStack());
        if (descriptor.isEmpty()) {
            this.loadSkin();
            return;
        }
        String newName = this.nameTextField.text();
        if (newName.isEmpty()) {
            this.toast(this.getDisplayText("error.noFileName", new Object[0]));
            return;
        }
        String newPath = SkinFileUtils.normalize(SkinFileUtils.concat(this.selectedPath, newName + ".armour"), true);
        if (this.selectedLibrary.get(newPath) != null) {
            if (!this.isAuthorized()) {
                this.toast(this.getDisplayText("error.illegalOperation", new Object[0]));
                return;
            }
            this.overwriteItem(newPath, () -> this.saveSkin(descriptor, newPath));
            return;
        }
        this.saveSkin(descriptor, newPath);
    }

    private void removeItem(UIControl sender) {
        SkinLibraryFile file;
        block5: {
            block4: {
                ISkinLibrary.Entry entry = this.selectedFile;
                if (!(entry instanceof SkinLibraryFile)) break block4;
                file = (SkinLibraryFile)entry;
                if (this.isAuthorized()) break block5;
            }
            return;
        }
        ConfirmDialog dialog = new ConfirmDialog();
        dialog.setTitle(this.getDisplayText("dialog.delete.title", new Object[0]));
        dialog.setMessageColor(new UIColor(0xFF5555));
        dialog.setConfirmText(this.getDisplayText("dialog.delete.delete", new Object[0]));
        dialog.setCancelText(this.getDisplayText("dialog.delete.close", new Object[0]));
        dialog.setMessage(this.getDisplayText("dialog.delete.deleteFile", file.getName()));
        if (file.isDirectory()) {
            dialog.setMessage(this.getDisplayText("dialog.delete.deleteFolder", file.getName()));
        }
        dialog.showInView(this, () -> {
            if (!dialog.isCancelled()) {
                this.selectedLibrary.delete(file);
            }
        });
    }

    private void renameItem(String sender) {
        SkinLibraryFile file;
        block6: {
            block5: {
                ISkinLibrary.Entry entry = this.selectedFile;
                if (!(entry instanceof SkinLibraryFile)) break block5;
                file = (SkinLibraryFile)entry;
                if (this.isAuthorized()) break block6;
            }
            return;
        }
        if (sender.equals(file.getName())) {
            return;
        }
        String ext = file.isDirectory() ? "" : ".armour";
        String newPath = SkinFileUtils.normalize(file.getPath() + "/../" + sender + ext, true);
        if (this.selectedLibrary.get(newPath) != null) {
            this.overwriteItem(newPath, () -> this.selectedLibrary.rename(file, newPath));
            return;
        }
        this.selectedLibrary.rename(file, newPath);
    }

    private void overwriteItem(String path, Runnable handler) {
        ConfirmDialog dialog = new ConfirmDialog();
        dialog.setTitle(this.getDisplayText("dialog.overwrite.title", new Object[0]));
        dialog.setMessage(this.getDisplayText("dialog.overwrite.overwriteFile", SkinFileUtils.getBaseName(path)));
        dialog.setMessageColor(new UIColor(0xFF5555));
        dialog.setConfirmText(this.getDisplayText("dialog.overwrite.ok", new Object[0]));
        dialog.setCancelText(this.getDisplayText("dialog.overwrite.close", new Object[0]));
        dialog.showInView(this, () -> {
            if (!dialog.isCancelled()) {
                handler.run();
            }
        });
    }

    private void toast(NSString message) {
        ConfirmDialog dialog = new ConfirmDialog();
        dialog.setTitle(NSString.localizedString("skin-library-global.panel.info", new Object[0]));
        dialog.setMessage(message);
        dialog.setMessageColor(new UIColor(0xFF5555));
        dialog.showInView(this);
    }

    private void refreshLibrary(UIControl sender) {
        this.selectedLibrary.reload();
    }

    private void selectFile(UIControl sender) {
        boolean isFile;
        ISkinLibrary.Entry newValue;
        ISkinLibrary.Entry oldValue = this.selectedFile;
        this.selectedFile = newValue = this.fileList.getSelectedItem();
        boolean bl = isFile = newValue != null && (!newValue.isDirectory() || !newValue.getName().equals(".."));
        if (isFile) {
            this.nameTextField.setText(newValue.getName());
        } else {
            this.nameTextField.setText("");
        }
        this.reloadStatus();
        if (newValue != null && newValue.isDirectory() && oldValue == newValue) {
            this.setSelectedPath(newValue.getPath());
            this.reloadData(sender);
        }
    }

    private UIButton buildIconButton(int x, int y, int u, int v, int width, int height) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setImage(ModTextures.iconImage(u, v, width, height, ModTextures.SKIN_LIBRARY), 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        return button;
    }

    private void saveSkin(SkinDescriptor descriptor, String path) {
        ModLog.debug("save skin of '{}' to '{}'", descriptor.getIdentifier(), path);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.RENDERER);
        if (bakedSkin == null || !((SkinLibraryMenu)this.menu).shouldSaveStack()) {
            ModLog.debug("can't save unbaked skin of '{}'", descriptor);
            return;
        }
        SaveSkinPacket packet = new SaveSkinPacket(descriptor.getIdentifier(), this.selectedLibrary.getNamespace() + ":" + path);
        if (!packet.isReady(this.playerInventory.f_35978_)) {
            ModLog.debug("can't save skin of '{}'", descriptor);
            this.toast(this.getDisplayText("error.illegalOperation", new Object[0]));
            return;
        }
        NetworkManager.sendToServer(packet);
    }

    private void loadSkin() {
        if (this.selectedFile == null || this.selectedFile.isDirectory() || !((SkinLibraryMenu)this.menu).shouldLoadStack()) {
            return;
        }
        DataDomain source = DataDomain.DATABASE;
        if (this.trackCheckBox.isSelected()) {
            source = DataDomain.DATABASE_LINK;
        }
        String identifier = this.selectedFile.getSkinIdentifier();
        SkinDescriptor descriptor = new SkinDescriptor(identifier, this.selectedFile.getSkinType(), ColorScheme.EMPTY);
        ModLog.debug("load skin of '{}'", identifier);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.RENDERER);
        if (bakedSkin == null) {
            ModLog.debug("can't load unbaked skin of '{}'", identifier);
            return;
        }
        SaveSkinPacket packet = new SaveSkinPacket(descriptor.getIdentifier(), source.normalize(""));
        if (!packet.isReady(this.playerInventory.f_35978_)) {
            ModLog.debug("can't load skin of '{}'", descriptor);
            this.toast(this.getDisplayText("error.illegalOperation", new Object[0]));
            return;
        }
        NetworkManager.sendToServer(packet);
    }

    private void setSelectedPath(String newSelectedPath) {
        if (Objects.equals(this.selectedPath, newSelectedPath)) {
            return;
        }
        this.contentOffsets.put(this.selectedPath, this.fileList.contentOffset());
        if (newSelectedPath.startsWith(this.selectedPath)) {
            this.contentOffsets.remove(newSelectedPath);
        }
        this.selectedPath = newSelectedPath;
    }

    private boolean hasInputSkin() {
        return !SkinDescriptor.of(((SkinLibraryMenu)this.menu).getInputStack()).isEmpty();
    }

    private boolean isAuthorized() {
        if (this.selectedLibrary == this.libraryManager.getPublicSkinLibrary()) {
            return this.libraryManager.shouldMaintenanceFile(this.inventory.f_35978_);
        }
        return true;
    }
}

