/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.panels;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIFont;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.client.gui.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermission;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeaderLibraryPanel
extends AbstractLibraryPanel {
    private final ArrayList<UIButton> rightButtons = new ArrayList();
    private final UIButton iconButtonHome = this.addRightButton(0, 0, "home", this.redirect(GlobalSkinLibraryWindow.Page.HOME));
    private final UIButton iconButtonMyFiles = this.addRightButton(0, 34, "myFiles", this.redirect(GlobalSkinLibraryWindow.Page.LIST_USER_SKINS));
    private final UIButton iconButtonUploadSkin = this.addRightButton(0, 51, "uploadSkin", "uploadSkinBan", this.redirect(GlobalSkinLibraryWindow.Page.SKIN_UPLOAD));
    private final UIButton iconButtonJoin = this.addRightButton(0, 68, "join", this.redirect(GlobalSkinLibraryWindow.Page.LIBRARY_JOIN));
    private final UIButton iconButtonInfo = this.addRightButton(0, 17, "info", this.redirect(GlobalSkinLibraryWindow.Page.LIBRARY_INFO));
    private final UIButton iconButtonModeration = this.addRightButton(0, 119, "moderation", this.redirect(GlobalSkinLibraryWindow.Page.LIBRARY_MODERATION));
    private final GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();
    private PlayerTextureDescriptor playerTexture;

    public HeaderLibraryPanel() {
        super("skin-library-global.header", p -> true);
        this.reloadData();
    }

    @Override
    public void tick() {
        super.tick();
        this.reloadData();
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect bounds = this.bounds();
        float x2 = bounds.width - 4.0f;
        for (UIButton button : this.rightButtons) {
            if (button.isHidden()) continue;
            CGRect frame = button.frame();
            button.setFrame(new CGRect(x2 - frame.width, (bounds.height - frame.height) / 2.0f, frame.width, frame.height));
            x2 = button.frame().getMinX() - 2.0f;
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        this.renderPlayerProfile(context, Minecraft.m_91087_().m_91094_().m_92548_());
    }

    public void reloadData() {
        this.iconButtonHome.setHidden(false);
        this.iconButtonMyFiles.setHidden(true);
        this.iconButtonUploadSkin.setHidden(true);
        this.iconButtonJoin.setHidden(true);
        this.iconButtonInfo.setHidden(false);
        this.iconButtonModeration.setHidden(true);
        ServerUser user = this.library.getUser();
        if (!user.isMember() && this.library.isConnected()) {
            this.iconButtonJoin.setHidden(false);
        }
        if (user.isMember()) {
            this.iconButtonMyFiles.setHidden(false);
            this.iconButtonUploadSkin.setHidden(false);
            this.iconButtonUploadSkin.setEnabled(user.hasPermission(ServerPermission.SKIN_UPLOAD));
            if (user.hasPermission(ServerPermission.GET_REPORT_LIST)) {
                this.iconButtonModeration.setHidden(false);
            }
        }
        this.setNeedsLayout();
    }

    private void renderPlayerProfile(CGGraphicsContext context, GameProfile gameProfile) {
        if (this.playerTexture == null) {
            this.playerTexture = PlayerTextureDescriptor.fromProfile(gameProfile);
        }
        float tx = 5.0f;
        float ty = 5.0f;
        IResourceLocation texture = PlayerTextureLoader.getInstance().loadTextureLocation(this.playerTexture);
        context.drawResizableImage(texture, tx, ty, 16.0f, 16.0f, 8.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f, 0.0f);
        context.drawResizableImage(texture, tx - 1.0f, ty - 1.0f, 18.0f, 18.0f, 40.0f, 8.0f, 8.0f, 8.0f, 64.0f, 64.0f, 0.0f);
        CGRect rect = this.bounds();
        NSMutableString profile = new NSMutableString(" - ");
        profile.append(gameProfile.getName());
        int textColor = 0xFFAAAA;
        ServerUser user = this.library.getUser();
        if (user.isMember()) {
            textColor = 0xFFFFAA;
        }
        if (user.isAuthenticated()) {
            textColor = 0xAAFFAA;
        }
        float lineHeight = UIFont.systemFont().lineHeight();
        context.drawText(profile, 24.0f, (rect.height - lineHeight) / 2.0f, textColor);
    }

    private BiConsumer<HeaderLibraryPanel, UIControl> redirect(GlobalSkinLibraryWindow.Page page) {
        return (self, sender) -> {
            switch (page) {
                case HOME: {
                    self.router.showNewHome();
                    break;
                }
                case LIST_USER_SKINS: {
                    self.router.showSkinList(this.library.getUser());
                    break;
                }
                default: {
                    self.router.showPage(page);
                }
            }
        };
    }

    private UIButton addRightButton(int u, int v, String key, BiConsumer<HeaderLibraryPanel, UIControl> handler) {
        return this.addRightButton(u, v, key, null, handler);
    }

    private UIButton addRightButton(int u, int v, String key, String key2, BiConsumer<HeaderLibraryPanel, UIControl> handler) {
        UIButton button = new UIButton(new CGRect(0.0f, 0.0f, 18.0f, 18.0f));
        button.setImage(ModTextures.iconImage(u, v, 16.0f, 16.0f, ModTextures.GLOBAL_SKIN_LIBRARY), 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.setTooltip(this.getDisplayText(key, new Object[0]), 0);
        if (key2 != null) {
            button.setTooltip(this.getDisplayText(key2, new Object[0]), 4);
        }
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, handler);
        this.addSubview(button);
        this.rightButtons.add(button);
        return button;
    }
}

