/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.ReportType;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;

public class ServerSkin {
    protected String id;
    protected String userId;
    protected String name;
    protected String description;
    protected int downloads = 0;
    protected float rating = 0.0f;
    protected int ratingCount = 0;
    public boolean showsDownloads = true;
    public boolean showsRating = false;
    public boolean showsGlobalId = true;
    protected final SkinDescriptor descriptor;

    public ServerSkin(String id, String name, SkinDescriptor descriptor) {
        this.id = id;
        this.name = name;
        this.descriptor = descriptor;
    }

    public ServerSkin(IDataPackObject object) {
        this.id = object.get("id").stringValue();
        this.userId = object.get("user_id").stringValue();
        this.name = object.get("name").stringValue();
        this.description = object.get("description").stringValue();
        this.descriptor = new SkinDescriptor(DataDomain.GLOBAL_SERVER_PREVIEW.normalize(this.id));
        this.showsDownloads = object.has("downloads");
        if (this.showsDownloads) {
            this.downloads = object.get("downloads").intValue();
        }
        if (object.has("rating")) {
            this.rating = object.get("rating").floatValue();
            this.showsRating = true;
        }
        if (object.has("rating_count")) {
            this.ratingCount = object.get("rating_count").intValue();
            this.showsRating = true;
        }
    }

    public void update(String name, String desc, IResultHandler<ServerSkin> handler) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", name);
        parameters.put("description", desc);
        parameters.put("skinId", this.id);
        parameters.put("skinOwner", this.userId);
        this.getLibrary().request("/skin/edit", parameters, null, (response, exception) -> {
            if (exception == null) {
                this.name = name;
                this.description = desc;
                handler.accept(this);
            } else {
                handler.throwing(exception);
            }
        });
    }

    public void getRate(IResultHandler<Integer> handler) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("skinId", this.id);
        this.getLibrary().request("/skin/rating", parameters, o -> o.get("rating").intValue(), handler);
    }

    public void updateRate(int rate, IResultHandler<Integer> handler) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("skinId", this.id);
        parameters.put("rating", rate);
        this.getLibrary().request("/skin/rate", parameters, o -> o.get("rating").intValue(), (rating, exception) -> {
            if (exception == null) {
                this.rating = rating.intValue();
            }
            handler.apply(rate, exception);
        });
    }

    public void remove(IResultHandler<Void> handler) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("skinId", this.id);
        parameters.put("skinOwner", this.userId);
        this.getLibrary().request("/skin/delete", parameters, null, handler);
    }

    public void report(String message, ReportType reportType, IResultHandler<Void> handler) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("reportSkinId", this.id);
        parameters.put("reportType", reportType.toString());
        parameters.put("reportMessage", message);
        this.getLibrary().request("/skin/report", parameters, null, handler);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public ServerUser getUser() {
        return this.getLibrary().getUserById(this.userId);
    }

    public SkinDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setRatingCount(int ratingCount) {
        this.ratingCount = ratingCount;
    }

    public int getRatingCount() {
        return this.ratingCount;
    }

    public int getDownloads() {
        return this.downloads;
    }

    public float getRating() {
        return this.rating;
    }

    private GlobalSkinLibrary getLibrary() {
        return GlobalSkinLibrary.getInstance();
    }
}

